﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="FavoriteProduct.aspx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.User.Shop.FavoriteProduct" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>
        <asp:Localize ID="LocalizePageTitle" Text="<%$ Res: User_Shop_FavoriteProduct_PageTitle,我收藏的商品 %>"
            runat="server" /></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li class="hover"><span><a href="javascript:void(0)">
                    <asp:Localize ID="Localize4" Text="<%$ Res: User_Shop_FavoriteProduct_PageTitle,我收藏的商品 %>"
                        runat="server" /></a></span></li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="EgvFavorite" DataKeyNames="InfoId" runat="server"
                AllowPaging="True" AutoGenerateColumns="False" AutoGenerateCheckBoxColumn="true"
                ItemName="<%$ Res: User_Contents_Favorite_EgvFavorite,收藏 %>" SerialText="" CheckBoxFieldHeaderWidth="3%"
                DataSourceID="OdsFavorite">
                <Columns>
                    <pe:BoundField DataField="InfoId" HeaderStyle-Width="6%" HeaderText="ID" SortExpression="InfoId" />
                    <pe:TemplateField>
                        <HeaderTemplate>
                            <asp:Localize ID="Localize1" Text="<%$ Res: User_Shop_Favorite_Title,商品名称 %>" runat="server" /></HeaderTemplate>
                        <ItemTemplate>
                            <a target="_blank" href='<%# BasePath + "Item.aspx?id=" +  Eval("InfoId").ToString() %>'>
                                <%# Eval("Title") %>
                            </a>
                        </ItemTemplate>
                        <ItemStyle HorizontalAlign="Left" />
                    </pe:TemplateField>
                    <pe:BoundField DataField="FavoriteTime" HeaderStyle-Width="18%" HeaderText="<%$ Res: User_Contents_Favorite_BoundField2,收藏时间 %>"
                        SortExpression="FavoriteTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="false" />
                    <pe:TemplateField HeaderText="<%$ Res: User_Contents_Favorite_TemplateField2,操作 %>">
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedNodeAnchor ID="EahContentView" IsChecked="false" href='<%# "FavoriteProduct.aspx?Action=Delete&Id=" + Eval("InfoId")%>'
                                runat="server">
                                <asp:Localize ID="Localize2" Text="<%$ Res: User_Contents_Favorite_Localize2,取消收藏 %>"
                                    runat="server" /></pe:ExtendedNodeAnchor>
                        </ItemTemplate>
                    </pe:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
        </div>
    </div>
    <div class="clear">
    </div>
    <div class="model_list_manage">
        <label for="ChkAll" class="checkbox">
            <input id="ChkAll" type="checkbox" />
            <asp:Localize ID="Localize3" Text="<%$ Res: User_Contents_Favorite_Localize3,选中本页显示的所有项目 %>"
                runat="server" /></label>
        <asp:Button ID="BtnBatchDelete" CssClass="input_button_seven" runat="server" Text="<%$ Res: User_Contents_Favorite_BtnBatchDelete,取消选中的收藏 %>"
            OnClick="BtnBatchDelete_Click" />
        <asp:Button ID="BtnAddShoppingCart" CssClass="input_button_eight" runat="server"
            Text="<%$ Res: User_Contents_Favorite_BtnAddToShoppingCart,批量添加至购物车 %>" OnClick="BtnAddShoppingCart_Click" />
    </div>
    <asp:ObjectDataSource ID="OdsFavorite" runat="server" SelectMethod="GetList" SelectCountMethod="GetTotalOfFavorite"
        TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.Favorite" EnablePaging="True"
        MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:Parameter Name="userId" Type="int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="nodeId" QueryStringField="NodeId"
                Type="Int32" />
            <asp:Parameter Name="modelType" Type="int32" DefaultValue="2" />
        </SelectParameters>
    </asp:ObjectDataSource>
    </div>
    </form>
</body>
</html>
