﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="MyOrders.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.User.Shop.MyOrders" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>我的订单</title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
	<div class="hdTitle">
		<h3><strong>订单中心</strong></h3>
		<div class="fr searchIn">
		<asp:TextBox ID="TxtKeyword" runat="server" value="" ToolTip="商品名称、商品编号、订单编号"  />
		<asp:Button runat="server" ID="BtnSearch" Text="查询" OnClick="BtnSearch_Click" />
		</div>
		<script type="text/javascript">
		jQuery(".searchIn #TxtKeyword").bind("focus", function(){
			jQuery(this).css("color", "#333");
		});
		</script>
	</div>
	<div class="bdCont">
		<div class="memberBoxTab">
			<div class="hd ">
				<ul class="hdTab fl">
					<li id="TabTitle0" class="on"><span><a href="MyOrders.aspx">我的所有订单</a></span></li>
                            <li id="TabTitle5"><span><a href="MyOrders.aspx?Type=5">待支付订单</a></span></li>
                            <li id="TabTitle8"><span><a href="MyOrders.aspx?Type=8">待确认收货</a></span></li>
                            <li id="TabTitle16"><span><a href="MyOrders.aspx?Type=16">已取消订单</a></span></li>
                        </ul>
				<span class="fr orderDate" >
                            <asp:DropDownList ID="DropOrderType" runat="server" AutoPostBack="true">
                                <asp:ListItem Text="最近一个月订单" Selected="True" Value="30" />
                                <asp:ListItem Text="最近三个月订单" Value="31" />
                                <asp:ListItem Text="三个月前的订单" Value="32" />
                            </asp:DropDownList>
                        </span>
                    </div>
			<div class="bd orderList">
                        <pe:ExtendedRepeater runat="server" ID="RptMyOrderList" OnItemDataBound="RptMyOrderList_ItemDataBound">
                            <HeaderTemplate>
                                <table cellpadding="0" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="o-num">
                                                订单编号
                                            </th>
                                            <th class="o-consignee">
                                                收货人
                                            </th>
                                            <th class="o-price">
                                                订单金额
                                            </th>
                                            <th class="o-time">
                                                下单时间
                                            </th>
                                            <th class="o-status">
                                                订单及物流状态
                                            </th>
                                            <th class="o-action">
                                                操作
                                            </th>
                                        </tr>
                                    </thead>
                            </HeaderTemplate>
                            <FooterTemplate>
                                <tfoot>
                                    <tr>
                                        <td colspan="6">
                                            <span>等待付款订单数：<em><asp:Literal ID="LitWaitPaymentCount" runat="server" /></em></span>
                                            <span>未完成的订单数：<em><asp:Literal ID="LitNoEndCount" runat="server" /></em></span>
                                            <span>已完成的订单数：<em><asp:Literal ID="LitEndCount" runat="server" /></em></span> <span>
                                                已取消订单数：<em><asp:Literal ID="LitCancelCount" runat="server" /></em></span> <span>订单总数：<em><asp:Literal
                                                    ID="LitOrderCount" runat="server" /></em></span>
                                        </td>
                                    </tr>
                                </tfoot>
                                </table>
                            </FooterTemplate>
                            <ItemTemplate>
                                <tr class="close">
                                    <td class="o-num">
                                        <a href="javascript:;" onclick="ShowOrderItem(this.rel)" class="btn-detail" rel='<%#Eval("OrderNum")%>'>
                                        </a><a href='ShowOrder.aspx?OrderId=<%# Eval("OrderId") %>'>
                                            <%#Eval("OrderNum")%></a>
                                    </td>
                                    <td class="o-consignee">
                                        <%#Eval("ContacterName")%>
                                    </td>
                                    <td class="o-price">
                                        ￥<%#Eval("MoneyTotal") %><br /><pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitPayStatus" /></td>
                                    <td class="o-time">
                                        <pe:ExtendedLiteral ID="LitInputTime" runat="server" />
                                    </td>
                                    <td class="o-status">
                                        <pe:ExtendedLiteral HtmlEncode="false" ID="LitOrderStatus" runat="server" />
                                    </td>
                                    <td class="o-action">
                                        <asp:LinkButton runat="server" CausesValidation="false" ID="LBtnModify" CommandName="Modify" OnCommand="LBtnModify_Command" Text="修改" CommandArgument='<%# Eval("OrderId") %>' />&nbsp;
                                        <asp:LinkButton runat="server" CausesValidation="false" ID="LBtnCancel"  CommandName="Cancel" OnCommand="LBtnCancel_Command" Text="取消" CommandArgument='<%# Eval("OrderId").ToString() + "|" +Eval("OrderNum").ToString() %>' />
                                    </td>
                                </tr>
                                <tr class="item-list" style="display: none;" id='l-<%#Eval("OrderNum")%>'>
                                    <td colspan="7">
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </pe:ExtendedRepeater>
                        <table cellpadding="0" cellspacing="0" runat="server" id="TableEmpty">
                            <tr>
                                <td style="height: 100px;" align="center" valign="middle">
                                    暂无订单！
                                </td>
                            </tr>
                        </table>
                        <div class="pages">
                            <span class="pagecss">
                                <pe:AspNetPager ID="Pager" runat="server" OnPageChanged="Pager_PageChanged">
                                </pe:AspNetPager>
                            </span>
            </div>
        </div>
    </div>
	</div>
    <script type="text/javascript">
        Request = {
            QueryString: function (item) {
                var svalue = location.search.match(new RegExp("[\?\&]" + item + "=([^\&]*)(\&?)", "i"));
                return svalue ? svalue[1] : svalue;
            }
        };
        var t = parseInt(Request.QueryString("Type"));
        t = isNaN(t) ? 0 : t;
        jQuery("li[id^='TabTitle']").removeClass("on");
        jQuery("#TabTitle" + t.toString()).addClass("on");
		// jq select
		jQuery(".memberBoxTab .hd span.fr select").styledSelect({
			selectClass: 'PESelect',
			selectedOptionClass: 'current'
		});
    </script>

    </form>
</body>
</html>
