﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="OrderModify.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.User.Shop.OrderModify" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>修改订单信息</title>
</head>
<body>
    <pe:extendedsitemappath id="YourPosition" sitemapprovider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">



        <div class="hdTitle">
            <h3><strong>订单信息</b>（订单编号：<asp:Label ID="LblOrderNum" runat="server" />）</strong></h3>
        </div>
        <div class="bdCont">

            <div class="model_info_content">

                <table class="tableStyle tableStyleBorder">
                    <tr>
                        <td colspan="2">客户名称：<asp:Label ID="LblClientName" runat="server" Style="color: #ff0000;" />
                        </td>
                        <td>用 户 名：<asp:Label ID="LblUserName" runat="server" Style="color: #ff0000;" />
                        </td>
                        <td colspan="2">下单时间：<asp:Label ID="LblInputTime" runat="server" Style="color: #ff0000;" />
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 15%;">需要发票：<asp:Label ID="LblNeedInvoice" runat="server" />
                        </td>
                        <td style="width: 15%;">已开发票：<asp:Label ID="LblInvoiced" runat="server" />
                        </td>
                        <td style="width: 20%;">订单状态：<pe:extendedlabel htmlencode="false" id="LblStatus" runat="server" />
                        </td>
                        <td style="width: 20%;">付款情况：<pe:extendedlabel htmlencode="false" id="LblMoneyTotal" runat="server" />
                        </td>
                        <td style="width: 20%;">物流状态：<pe:extendedlabel htmlencode="false" id="LblDeliverStatus" runat="server" />
                        </td>
                    </tr>
                </table>

                <table class="tableStyle tableStyleBorder">
                    <tr>
                        <td style="width: 15%;" class="ok_tab">收货人姓名：
                        </td>
                        <td style="width: 30%;" align="left">
                            <asp:TextBox ID="TxtContacterName" runat="server" Width="80px" CssClass="inputxt"
                                MaxLength="50" />
                            <pe:requiredfieldvalidator id="ValrContacterName" display="Dynamic" text="请输入收货人姓名！"
                                controltovalidate="TxtContacterName" setfocusonerror="true" runat="server" errormessage="RequiredFieldValidator"></pe:requiredfieldvalidator>
                        </td>
                        <td style="width: 15%;" class="ok_tab">联系电话：
                        </td>
                        <td style="width: 30%;" align="left">
                            <asp:TextBox ID="TxtPhone" runat="server" MaxLength="50" CssClass="inputxt" />
                            <pe:regexvalidator validatetype="Mobile" id="VtelPhone" controltovalidate="TxtPhone"
                                setfocusonerror="true" display="dynamic" errormessage="收货人电话格式不正确" runat="server"></pe:regexvalidator>
                            <asp:CustomValidator ID="ValxPhone" ClientValidationFunction="ValxPhone_ClientValidate"
                                Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server"
                                ErrorMessage="至少要输入收货人电话和收货人手机中的一个" ControlToValidate="TxtPhone">
                            </asp:CustomValidator>
                        </td>
                    </tr>
                    <tr valign="top">
                        <td style="width: 13%;" class="ok_tab">收货人地址：
                        </td>
                        <td style="width: 37%;" align="left">
                            <asp:TextBox ID="TxtAddress" disabled="disabled" runat="server" Width="200px" CssClass="inputxt" MaxLength="255" />
                            <pe:requiredfieldvalidator id="ValrAddress" display="Dynamic" text="请输入收货人地址！" setfocusonerror="true"
                                controltovalidate="TxtAddress" runat="server" errormessage="RequiredFieldValidator"></pe:requiredfieldvalidator>
                        </td>
                        <td style="width: 13%;" class="ok_tab">邮政编码：
                        </td>
                        <td style="width: 37%;" align="left">
                            <asp:TextBox ID="TxtZipCode" disabled="disabled" runat="server" MaxLength="10" CssClass="inputxt" />
                            <pe:requiredfieldvalidator id="ValrZipCode" display="Dynamic" text="请输入邮政编码！" setfocusonerror="true"
                                controltovalidate="TxtZipCode" runat="server" errormessage="RequiredFieldValidator"></pe:requiredfieldvalidator>
                            <pe:regexvalidator
                                validatetype="ZipCode" id="VzipZipCode" controltovalidate="TxtZipCode" display="dynamic"
                                setfocusonerror="true" runat="server"></pe:regexvalidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 13%;" class="ok_tab">收货人邮箱：
                        </td>
                        <td style="width: 37%;" align="left">
                            <asp:TextBox ID="TxtEmail" runat="server" MaxLength="50" CssClass="inputxt" />
                            <pe:requiredfieldvalidator id="ValrEmail" display="Dynamic" setfocusonerror="true"
                                text="请输入收货人邮箱！" controltovalidate="TxtEmail" runat="server" errormessage="RequiredFieldValidator"></pe:requiredfieldvalidator>
                            <pe:regexvalidator
                                validatetype="Email" id="VmailEmail" controltovalidate="TxtEmail" display="dynamic"
                                setfocusonerror="true" runat="server"></pe:regexvalidator>
                        </td>
                        <td style="width: 13%;" class="ok_tab">收货人手机：
                        </td>
                        <td style="width: 37%;" align="left">
                            <asp:TextBox ID="TxtMobile" runat="server" MaxLength="50" CssClass="inputxt" />
                            <pe:regexvalidator validatetype="Mobile" id="VmblMobile" controltovalidate="TxtMobile"
                                display="dynamic" setfocusonerror="true" errormessage="收货人手机格式不正确" runat="server"></pe:regexvalidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 13%;" class="ok_tab">送货方式：
                        </td>
                        <td style="width: 37%;" align="left">
                            <asp:DropDownList ID="DropDeliverType" DataTextField="TypeName" DataValueField="TypeId"
                                runat="server">
                            </asp:DropDownList>
                        </td>
                        <td style="width: 13%;" class="ok_tab">购买日期：
                        </td>
                        <td style="width: 37%;" align="left">
                            <asp:Label ID="LblBuyDate" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" class="ok_tab">付款方式：
                        </td>
                        <td align="left">
                            <asp:DropDownList ID="DropPaymentType" DataTextField="TypeName" DataValueField="TypeId"
                                runat="server">
                            </asp:DropDownList>
                        </td>
                        <td align="right"></td>
                        <td align="left"></td>
                    </tr>
                </table>
                <div class="okBottom">
                    <asp:Button ID="BtnOrderModify" runat="server" CssClass="submit_button" Text="<%$ Res: User_Shop_ShowOrder_BtnOrderModify,修改 %>"
                        OnClick="BtnOrderModify_Click" />
                    <asp:Button ID="BtnReturn" runat="server" OnClick="BtnReturn_Click" CssClass="submit_button"
                        CausesValidation="false" Text="<%$ Res: Shop_Payment_BtnReturn,取消 %>" />
                </div>
            </div>
        </div>
        <div class="model_Info_Tips">
            <span>注意：如需修改收货地址请联系管理员</span>
        </div>
        <asp:HiddenField ID="HdnOrderId" runat="server" />
        <asp:HiddenField ID="HdnState" runat="server" />
        <asp:HiddenField ID="HdnMoneyTotal" runat="server" />
        <asp:HiddenField ID="HdnMoneyGoods" runat="server" />
        <asp:HiddenField ID="HdnDiscountPayment" runat="server" />
        <asp:HiddenField ID="HdnCouponID" runat="server" />
        <script language="javascript" type="text/javascript">
            function ValxPhone_ClientValidate(s, e) {
                var phone = document.getElementById('<%=TxtPhone.ClientID %>').value;
            var mobile = document.getElementById('<%=TxtMobile.ClientID %>').value;
            if (phone == "" && mobile == "") {
                e.IsValid = false;
            }
            else {
                e.IsValid = true;
            }
        }
        </script>

    </form>
</body>
</html>
