﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Wholesale.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.User.Shop.Wholesale" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li class="hover"><span><a href="javascript:void(0)">
                    <asp:Localize ID="Localize4" Text="<%$ Res: User_Shop_Wholesale_Page,批发商品 %>" runat="server" /></a></span></li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="EgvProduct" runat="server" AutoGenerateCheckBoxColumn="true"
                DataKeyNames="GeneralId" AutoGenerateColumns="false" AllowPaging="true" DataSourceID="OdsProduct"
                OnRowDataBound="EgvProduct_RowDataBound">
                <Columns>
                    <pe:TemplateField HeaderText="<%$ Res: User_Shop_Wholesale_TemplateField1,商品名称 %>">
                        <ItemTemplate>
                            <asp:Literal ID="LtrProductName" runat="server"></asp:Literal>
                            <asp:HiddenField ID="HdnGeneralId" runat="server" />
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Shop_Wholesale_TemplateField2,类型 %>"
                        HeaderStyle-Width="10%">
                        <ItemTemplate>
                            <asp:Literal ID="LtrProductType" runat="server"></asp:Literal>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:BoundField HeaderText="<%$ Res: User_Shop_Wholesale_BoundField1,单位 %>" DataField="Unit"
                        HeaderStyle-Width="8%">
                    </pe:BoundField>
                    <pe:BoundField HeaderText="<%$ Res: User_Shop_Wholesale_BoundField2,库存量 %>" DataField="Stocks"
                        HeaderStyle-Width="6%">
                    </pe:BoundField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Shop_Wholesale_TemplateField3,原始价 %>"
                        HeaderStyle-Width="8%">
                        <ItemTemplate>
                            <asp:Literal ID="LtrPrice" runat="server"></asp:Literal>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Shop_Wholesale_TemplateField4,数量/价格 %>"
                        HeaderStyle-Width="10%">
                        <ItemTemplate>
                            <asp:Literal ID="LtrPrice1" runat="server"></asp:Literal>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Shop_Wholesale_TemplateField5,数量/价格 %>"
                        HeaderStyle-Width="10%">
                        <ItemTemplate>
                            <asp:Literal ID="LtrPrice2" runat="server"></asp:Literal>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Shop_Wholesale_TemplateField6,数量/价格 %>"
                        HeaderStyle-Width="10%">
                        <ItemTemplate>
                            <asp:Literal ID="LtrPrice3" runat="server"></asp:Literal>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Shop_Wholesale_TemplateField7,购买量 %>"
                        HeaderStyle-Width="8%">
                        <ItemTemplate>
                            <asp:TextBox ID="TxtAmount" Width="40px" Text="10" runat="server"></asp:TextBox>
                        </ItemTemplate>
                    </pe:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
            <asp:ObjectDataSource ID="OdsProduct" runat="server" SelectCountMethod="GetWholesaleProductTotal"
                SelectMethod="GetProductsList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Product"
                EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HdnProductType" Name="productType" DefaultValue="0"
                        Type="Int32" />
                    <asp:ControlParameter ControlID="DropSearch" Name="searchType" DefaultValue="0" Type="Int32" />
                    <asp:ControlParameter ControlID="DropField" Name="field" DefaultValue="" Type="string" />
                    <asp:ControlParameter ControlID="DropModel" Name="modelId" DefaultValue="0" Type="Int32" />
                    <asp:ControlParameter ControlID="TxtKeyword" Name="keyword" DefaultValue="" Type="String" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <asp:HiddenField ID="HdnProductType" runat="server" Value="0" />
        </div>
    </div>
    <div class="clear">
    </div>
    <div class="model_list_manage">
        <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
            for="ChkAll"><asp:Localize ID="Localize12" Text="<%$ Res: User_Shop_ProductManage_Localize12,选中本页显示的所有商品 %>" runat="server" /></label>
        <asp:Button ID="BtnBuy" Width="15%" runat="server" CssClass="input_button_eight"
            OnClientClick="return batchconfirm('确定要购买选中的商品吗？');" OnClick="BtnBuy_OnClick"
            Text="<%$ Res: User_Shop_Wholesale_BtnBuy,批量购买选中商品 %>" />
    </div>
    <div class="model_list_manage">
        <table border="0" cellpadding="2" cellspacing="1" class="border" width="100%">
            <tr class="tdbg">
                <td>
                    <asp:Localize ID="Localize1" Text="<%$ Res: User_Shop_Wholesale_Localize1,快速查找： %>"
                        runat="server" />
                    <asp:DropDownList ID="DropSearch" runat="server" AutoPostBack="true" OnSelectedIndexChanged="DropSearch_SelectedIndexChanged">
                        <asp:ListItem Value="0" Text="<%$ Res: User_Shop_Wholesale_ListItem1,所有商品 %>"></asp:ListItem>
                        <asp:ListItem Value="23" Text="<%$ Res: User_Shop_Wholesale_ListItem2,正常销售的商品 %>"></asp:ListItem>
                        <asp:ListItem Value="24" Text="<%$ Res: User_Shop_Wholesale_ListItem3,特价处理的商品 %>"></asp:ListItem>
                        <asp:ListItem Value="25" Text="<%$ Res: User_Shop_Wholesale_ListItem4,所有热销的商品 %>"></asp:ListItem>
                        <asp:ListItem Value="26" Text="<%$ Res: User_Shop_Wholesale_ListItem5,所有新品 %>"></asp:ListItem>
                        <asp:ListItem Value="27" Text="<%$ Res: User_Shop_Wholesale_ListItem6,所有精品商品 %>"></asp:ListItem>
                    </asp:DropDownList>
                </td>
                <td>
                    <asp:Localize ID="Localize2" Text="<%$ Res: User_Shop_Wholesale_Localize2,高级查询： %>"
                        runat="server" />
                    <asp:DropDownList ID="DropField" runat="server">
                        <asp:ListItem Value="ProductName" Text="<%$ Res: User_Shop_Wholesale_ListItem8,商品名称 %>"></asp:ListItem>
                        <asp:ListItem Value="ProductIntro" Text="<%$ Res: User_Shop_Wholesale_ListItem9,商品简介 %>"></asp:ListItem>
                        <asp:ListItem Value="ProductExplain" Text="<%$ Res: User_Shop_Wholesale_ListItem10,商品介绍 %>"></asp:ListItem>
                        <asp:ListItem Value="ProducerName" Text="<%$ Res: User_Shop_Wholesale_ListItem11,厂商 %>"></asp:ListItem>
                        <asp:ListItem Value="TrademarkName" Text="<%$ Res: User_Shop_Wholesale_ListItem12,品牌/商标 %>"></asp:ListItem>
                    </asp:DropDownList>
                    <asp:DropDownList ID="DropModel" DataTextField="ModelName" DataValueField="ModelId"
                        runat="server">
                    </asp:DropDownList>
                    <asp:TextBox ID="TxtKeyword" runat="server" CssClass="inputxt"></asp:TextBox>
                    <asp:Button ID="BtnSearch" CssClass="input_button" Text="<%$ Res: User_Shop_Wholesale_BtnSearch,搜索 %>" OnClick="BtnSearch_Click"
                        runat="server" />
                </td>
            </tr>
        </table>
    </div>
    </form>
</body>
</html>
