using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Reflection;
using System.Globalization;
using Shop.Model;
using Shop.Tools;
using System.Linq;
using System.Collections.Specialized;
using Shop.Bussiness;
namespace Shop
{

    public class P_UserQuestion : ShopPageUser
    {
        protected List<Lebi_User_Question> user_questions;
        protected List<Lebi_User_Answer> user_answers;
        protected string where;
        protected int recordCount;
        protected int type;
        protected override void LoadPage(string themecode, int siteid, string languagecode, string pcode)
        {
            if (CurrentUser.id == 0)
            {
                Response.Redirect(URL("P_Login", "" + HttpUtility.UrlEncode(RequestTool.GetRequestUrlNonDomain()) + "," + GetUrlToken(RequestTool.GetRequestUrlNonDomain())+ ""));
            }
            LoadTheme(themecode, siteid, languagecode, pcode);
            CurrentPage = B_Lebi_Theme_Page.GetModel("Code='P_UserQuestion'");
            type = Rint_Para("0");
            path = "<a href=\"" + URL("P_Index", "") + "\" class=\"home\" title=\"" + Tag("ҳ") + "\"><span>" + Tag("ҳ") + "</span></a><em class=\"home\">&raquo;</em><a href=\"" + URL("P_UserCenter", "") + "\"><span>" + Tag("Ա") + "</span></a><em>&raquo;</em><a class=\"text\"><span>" + Tag("ȫ") + "</span></a>";
            user_questions = B_Lebi_User_Question.GetList("", "Sort desc");
            where = "User_id=" + CurrentUser.id + "";
            user_answers = B_Lebi_User_Answer.GetList(where, "id asc", 20, 1);
            recordCount = B_Lebi_User_Answer.Counts(where);
        }
        public string QuestionName(int id)
        {
            Lebi_User_Question model = B_Lebi_User_Question.GetModel(id);
            if (model != null)
                return Lang(model.Name);
            return "";
        }
        public override string ThemePageMeta(string code, string tag)
        {
            string str = "";
            Lebi_Theme_Page theme_page = B_Lebi_Theme_Page.GetModel("Code='" + code + "'");
            if (theme_page == null)
                return "";
            switch (tag.ToLower())
            {
                case "description":
                    if (Lang(theme_page.SEO_Description) == "")
                        str = Lang(SYS.Description);
                    else
                        str = Lang(theme_page.SEO_Description);
                    break;
                case "keywords":
                    if (Lang(theme_page.SEO_Keywords) == "")
                        str = Lang(SYS.Keywords);
                    else
                        str = Lang(theme_page.SEO_Keywords);
                    break;
                default:
                    if (Lang(theme_page.SEO_Title) == "")
                        str = Tag("ȫ") + " - " + Tag("Ա");
                    else
                        str = Lang(theme_page.SEO_Title);
                    break;
            }
            return ThemePageMeta(code, tag, str);
        }
    }
}