﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="MdEditor.ascx.cs" Inherits="Math.userControls.MdEditor" %>



<div id="md_<%=guid %>"> 

     <div class="layui-tab " lay-filter="tab_<%=guid %>" >
              <ul class="layui-tab-title"> 
                  <asp:Literal runat="server" ID="tab_header"></asp:Literal> 
              </ul> 
              <div class="layui-tab-content">     
                    <asp:Literal runat="server" ID="tab_body"></asp:Literal> 
              </div> 
    </div>  

 
       <div id="editor_<%=guid %>">
            <textarea style="display:none;" id="txt_<%=guid %>"><%=Text %></textarea> 
      </div>
</div>

 

    <script>
        
       
         Editor_<%=guid %> = editormd("editor_<%=guid %>", {
            width: "100%",
          
            placeholder: "", 
            lineNumbers: true, 
            watch: true,
            tex: true,
             height:"<%=height%>",
            autoFocus:<%=autoFocus%>,
            path: "../javascript/pandao-markdown/lib/",
            toolbarIcons: function () {
                return ["bold", "h4", "link", "image", "|", "table", "|", "inlineMath", "blockMath", "handMath", "|", <%=toolbarText%>  ]
            },
             
            toolbarIconTexts: {
                inlineMath: "行内公式",
                blockMath: "块级公式",
                handMath: "在线手写",
                <%=toolbarIconTexts%>
            },

            toolbarHandlers: { 
                inlineMath: function (cm, icon, cursor, selection) {
                    if (selection == "") {
                        cm.replaceSelection("$$" + " " + "$$");
                    }
                    else {
                        cm.replaceSelection("$$" + selection + "$$");
                    }
                },

                blockMath: function (cm, icon, cursor, selection) {
                    if (selection == "") {
                        cm.replaceSelection("\r\n```math\r\n" + " " + "\r\n```\r\n");
                    }
                    else {
                        cm.replaceSelection("\r\n```math\r\n" + selection + "\r\n```\r\n");
                    }
                },

                handMath: function (cm, icon, cursor, selection)
                {
                    __pop("https://webdemo.myscript.com/views/math/index.html");
                },


  
           


                <%=toolbarHandler%>

            },
             
            imageUpload: true,
            imageFormats: ["jpg", "jpeg", "gif", "png", "bmp", "webp"],
            imageUploadURL: "save_img.aspx",
            saveHTMLToTextarea: true 

        });

 
        $("#md_<%=guid %> .submenu-item").click(
               function () {
                   var isblock = $(this).data("isblock");
                   if (isblock) { 
                       Editor_<%=guid %>.replaceSelection("\r\n```math\r\n" + $(this).data("math") + "\r\n```\r\n");
                   }
                   else { 
                   Editor_<%=guid %>.replaceSelection("$$" + $(this).data("math") + "$$")
                   }
               } );


    <%--    function setInline<%=guid %>(value)
        {
            Editor_<%=guid %>.replaceSelection("$$" + value + "$$")
        }
   
        function setBlock<%=guid %>(value)
        {
            Editor_<%=guid %>.replaceSelection("\r\n```math\r\n" + $(this).data("math") + "\r\n```\r\n");
        }--%>

</script>