﻿$.ajax({
    url: "server/ajaxtxt.txt",          // 【常用】请求的链接
    type: "post",                       // 【常用】获取的方式：post,get      ==》(默认: "GET") 请求方式 ("POST" 或 "GET")， 默认为 "GET"。注意：其它 HTTP 请求方法，如 PUT 和 DELETE 也可以使用，但仅部分浏览器支持。



    data: { "key": "test" },            // 【常用】请求参数信息
    // 发送到服务器的数据。将自动转换为请求字符串格式。
    // GET 请求中将附加在 URL 后。查看 processData 选项说明以禁止此自动转换。必须为 Key/Value 格式。如果为数组，jQuery 将自动为不同值对应同一个名称。如 {foo:["bar1", "bar2"]} 转换为 '&foo=bar1&foo=bar2'。

    processData: true,                  // (默认: true) 默认情况下，发送的数据将被转换为对象(技术上讲并非字符串) 以配合默认内容类型 "application/x-www-form-urlencoded"。如果要发送 DOM 树信息或其它不希望转换的信息，请设置为 false。
    contentType: "application/x-www-form-urlencoded",
    // (默认: "application/x-www-form-urlencoded") 发送信息至服务器时内容编码类型。默认值适合大多数应用场合。
    // 如果你明确地传递了一个 content-type 给 $.ajax() 那么它必定会发送给服务器（即使没有数据要发送）。



    // context: document.body,          // 这个对象用于设置 Ajax 相关回调函数的上下文。
    // 也就是说，让回调函数内 this 指向这个对象（如果不设定这个参数，那么 this 就指向调用本次 AJAX 请求时传递的 options 参数）。
    // 比如指定一个 DOM 元素作为 context 参数，这样就设置了 success 回调函数的上下文为这个 DOM 元素。
    // 例子：$.ajax({ url: "test.html", context: document.body, success: function(){ $(this).addClass("done"); }});


    cache: false,                       // 禁用ajax缓存              ==》jQuery 1.2 新功能。默认值: true，dataType 为 script 和 jsonp 时默认为 false。设置为 false 将不缓存此页面。
    ifModified: false,                  // (默认: false) 仅在服务器数据改变时获取新数据。使用 HTTP 包 Last-Modified 头信息判断。

    async: true,                        // 请求是否异步，默认为异步，这也是ajax重要特性
    global: true,                       // 是否启用全局的事件  true ：启用  false：不启用
    timeout: 2000,                      // 设置请求超时时间（毫秒）。此设置将覆盖全局设置。

    dataType: "json",                   // 【常用】返回数据的格式类型
    // "xml"    : 返回 XML 文档，可用 jQuery 处理。
    // "html"   : 返回纯文本 HTML 信息；包含的 script 标签会在插入 dom 时执行。
    // "script" : 返回纯文本 JavaScript 代码。不会自动缓存结果。除非设置了 "cache" 参数。注意：在远程请求时(不在同一个域下) ，所有 POST 请求都将转为 GET 请求。（因为将使用 DOM 的 script标签来加载）
    // "json"   : 返回 JSON 数据 。
    // "jsonp"  : JSONP 格式。使用 JSONP 形式调用函数时，如 "myurl?callback=?" jQuery 将自动替换 ? 为正确的函数名，以执行回调函数。
    // "text"   : 返回纯文本字符串

    // 【常用】提交前处理
    beforeSend: function () {
        if (config.developType === 1) {
            console.log("============ Mid_beforeSend");
        }
    },

    // 【常用】成功时处理
    success: function (data) {
        if (config.developType === 1) {
            console.log("============ Mid_success");
        }
    },

    // 【常用】失败时处理
    error: function () {
        if (config.developType === 1) {
            console.log("============ Mid_error");
        }
    },

    // 【常用】完成时处理
    complete: function () {
        if (config.developType === 1) {
            console.log("============ Mid_complete");
        }
    }
});