﻿// Images
// 参考网址1：https://www.cnblogs.com/liboxncg/p/7098349.html?tdsourcetag=s_pcqq_aiomsg
// 参考网址2：https://blog.csdn.net/renfufei/article/details/10360855
// 参考网址3：https://www.colabug.com/2004296.html


// 动态加载资源
// require.async:按需加载（后加载）
// require:提前加载
; define(function (require) {
    require.async (
        [
              "/Resource/Extend/libs/photoswipe/default-skin/default-skin.css?v=" + config.resourceVersion
            , "/Resource/Extend/libs/photoswipe/photoswipe.css?v=" + config.resourceVersion
            , "/Resource/Extend/libs/photoswipe/photoswipe-ui-default.min.js?v=" + config.resourceVersion
            , "/Resource/Extend/libs/photoswipe/photoswipe.min.js?v=" + config.resourceVersion
        ]
    );
});

// 图片展示插件
; gblab_images = {
    func: function () {
        // 参数配置
        this.config = {
            // 透明度 0-1
            bgOpacity: 0.8,

            // 幻灯片之间的间距比。例如，0.12将呈现为滑动视口宽度的12％（四舍五入）。
            spacing: 0.02,

            // 进行扩展（变焦）手势时，最大缩放级别。 2意味着图像可以从原始尺寸被放大2倍。尽量避免在这里巨大的价值，因为过大的图像可以在移动导致内存问题（特别是在iOS）。
            maxSpreadZoom: 2,

            // 左右导航
            arrowKeys: true,

            // 图片处于放大状态是否允许滑动到下一张
            allowPanToNext: true,

            // 滑动到最后一张是否可以继续循环到第一张
            loop: true,

            // 垂直拖动图片关闭弹层
            closeOnVerticalDrag: true,

            // 在页面上滚动关闭图集， 仅适用于没有硬件触摸支持的设备。备注：移动设备不会生效
            closeOnScroll: false,

            // 预加载，数组，默认[1,1]，是指在切换图片时，预先懒加载前后图片的张数，不能小于1。
            preload: [1, 2],
        };

        // 控件定义
        this.controls = {
            // 对象需要先进行赋值
            $imgs: null,
        };

        // 事件初始化
        this.init = function () {
            var that = this;

            // 初始化结构体
            that.createPhotoSwipeWrap();

            // 注册事件
            that.regEvents();
        };

        // 注册事件
        this.regEvents = function () {
            var that = this;
            $.each(that.controls.$imgs, function (i, item) {
                item.onclick = function () {
                    that.openPhotoSwipe(i);
                };
            });
        };

        // 具体业务
        this.openPhotoSwipe = function (indexNum) {
            var that = this;

            var pswpElement = document.querySelectorAll('.pswp')[0],
                $content_Img = that.controls.$imgs;

            // build items array
            var item = [];
            for (var i = 0, count = $content_Img.length; i < count; i++) {
                // 内容图片路径
                var content_img_src = $content_Img.eq(i).attr('src'),
                    // 内容详情 - 图片对象
                    details_img = new Image(),
                    // 缩放插件 - 图片对象
                    zoom_img = new Image();

                details_img.src = content_img_src;

                // 缩放插件直接显示原图，去除云图像处理
                if (content_img_src.indexOf('?x-oss-process') > -1) {
                    zoom_img.src = content_img_src.substring(0, content_img_src.indexOf('?x-oss-process'));
                }
                else {
                    zoom_img.src = content_img_src;
                }

                if (zoom_img.src !== 'http://statics.bzw315.com/themes/common/loading/loading.gif') {
                    item.push({
                        src: zoom_img.src,
                        w: zoom_img.width === 0 ? details_img.width : zoom_img.width,
                        h: zoom_img.height === 0 ? details_img.height : zoom_img.height
                    });
                }
            }

            // define options (if needed)
            var options = {

                // 第几张图片
                index: indexNum,

                // 透明度 0-1
                bgOpacity: that.config.bgOpacity,

                // 幻灯片之间的间距比。例如，0.12将呈现为滑动视口宽度的12％（四舍五入）。
                spacing: that.config.spacing,

                // 进行扩展（变焦）手势时，最大缩放级别。 2意味着图像可以从原始尺寸被放大2倍。尽量避免在这里巨大的价值，因为过大的图像可以在移动导致内存问题（特别是在iOS）。
                maxSpreadZoom: that.config.maxSpreadZoom,

                // 左右导航
                arrowKeys: that.config.arrowKeys,

                // 图片处于放大状态是否允许滑动到下一张
                allowPanToNext: that.config.allowPanToNext,

                // 滑动到最后一张是否可以继续循环到第一张
                loop: that.config.loop,

                // 垂直拖动图片关闭弹层
                closeOnVerticalDrag: that.config.closeOnVerticalDrag,

                // 在页面上滚动关闭图集， 仅适用于没有硬件触摸支持的设备。备注：移动设备不会生效
                closeOnScroll: that.config.closeOnVerticalDrag,

                // 预加载，数组，默认[1,1]，是指在切换图片时，预先懒加载前后图片的张数，不能小于1。
                // [1,2]：预先加载前两张和后两张
                preload: that.config.preload,

                // history & focus options are disabled on CodePen
                history: true,
                focus: true,

                // 动画时淡出逐渐变透明
                showHideOpacity: true,

                // 当PhotoSwipe激活后,自动播放幻灯片. 默认值 = false
                autoStartSlideshow: true,
                // 自动播放模式下，多长时间播放下一张.Default = 3000(毫秒)
                slideshowDelay: 1000,

                // 只有 iOS 支持 - 允许用户在缩放/平移模式下 用手势旋转图像. 默认值  = false
                allowRotationOnUserZoom: true,

                // 检查设备的方向是否改变。默认 = false
                enableUIWebViewRepositionTimeout: true,
                // 定时检查设备的方向是否改变的时间 默认 = 500(毫秒)
                uiWebViewResetPositionDelay: 500,

                showAnimationDuration: 0,
                hideAnimationDuration: 500
            };

            var gallery = new PhotoSwipe(pswpElement, PhotoSwipeUI_Default, item, options);
            gallery.init();
        }

        // 构建相册结构体
        this.createPhotoSwipeWrap = function () {
            // 如果不存在，则创建结构体
            var html = [];
            html.push('<div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">');

            html.push(' <div class="pswp__bg"></div>');

            html.push(' <div class="pswp__scroll-wrap">');

            html.push('     <div class="pswp__container">');
            html.push('         <div class="pswp__item"></div>');
            html.push('         <div class="pswp__item"></div>');
            html.push('         <div class="pswp__item"></div>');
            html.push('     </div>');

            html.push('     <div class="pswp__ui pswp__ui--hidden">');
            html.push('         <div class="pswp__top-bar">');
            html.push('             <div class="pswp__counter"></div>');
            html.push('             <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>');

            // 去除分享按妞
            //html.push('             <button class="pswp__button pswp__button--share" title="Share"></button>');

            html.push('             <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>');
            html.push('             <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>');
            html.push('             <div class="pswp__preloader">');
            html.push('                 <div class="pswp__preloader__icn">');
            html.push('                     <div class="pswp__preloader__cut">');
            html.push('                         <div class="pswp__preloader__donut"></div>');
            html.push('                     </div>');
            html.push('                 </div>');
            html.push('             </div>');
            html.push('         </div>');
            html.push('         <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">');
            html.push('             <div class="pswp__share-tooltip"></div>');
            html.push('         </div>');
            html.push('         <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)"></button>');
            html.push('         <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)"></button>');
            html.push('         <div class="pswp__caption">');
            html.push('             <div class="pswp__caption__center"></div>');
            html.push('         </div>');
            html.push('     </div>');

            html.push(' </div>');

            html.push('</div>');

            $('body').append(html.join(''));
        }
    }
}


// 全参数

//allowUserZoom: 允许用户双击放大 / 移动方式查看图片.默认值 = true
//autoStartSlideshow: 当PhotoSwipe激活后, 自动播放幻灯片.默认值 = false
//allowRotationOnUserZoom: 只有 iOS 支持 - 允许用户在缩放 / 平移模式下 用手势旋转图像.默认值 = false
//backButtonHideEnabled: 按返回键隐藏相册幻灯片.主要是 Android 和 Blackberry使用.支持 BB6, Android v2.1, iOS 4 以及更新版本.默认值 = true
//captionAndToolbarAutoHideDelay: 标题栏和工具栏自动隐藏的延迟时间.默认值为 = 5000(毫秒).如果设为 0 则不会自动隐藏(tap / 单击切换显隐)
//captionAndToolbarFlipPosition: 标题栏和工具栏切换位置(让 caption显示在底部而 toolbar显示在顶部).默认值 = false
//captionAndToolbarHide: 隐藏 标题栏和工具栏.默认值 = false
//captionAndToolbarOpacity: 标题栏和工具栏 的透明度(0 - 1).默认值 = 0.8
//captionAndToolbarShowEmptyCaptions: 即使当前图片的标题是空, 也显示标题栏.默认值 = true
//cacheMode: 缓存模式, Code.PhotoSwipe.Cache.Mode.normal(默认, 正常) 或者 Code.PhotoSwipe.Cache.Mode.aggressive(激进, 积极).决定 PhotoSwipe 如何管理图片缓存 cache.
//Aggressive 模式将会积极地地设置非 "当前，上一张,下一张"的图片为空的类型.对于老版本iOS 浏览器下的大图片内存溢出将会很有用.大多数情况下，normal模式就可以了。
//doubleTapSpeed: 双击的最大间隔.默认值 = 300(毫秒)
//doubleTapZoomLevel: 当用户双击的时候, 放大的倍数, 默认的 "zoom-in"(拉近) 级别.默认值 = 2.5
//enableDrag: 允许拖动上一张 / 下一张图片到当前界面.默认值 = true
//enableKeyboard: 允许键盘操作(左右箭头切换，Esc退出, Enter自动播放, 空格键 显 / 隐标题栏 / 退出).默认 = true
//enableMouseWheel: 允许鼠标滚轮操作.默认 = true
//fadeInSpeed: 淡入效果元素的速度(持续时间), 毫秒.默认 = 250
//fadeOutSpeed: 淡出效果元素的速度(持续时间), 毫秒.默认 = 250
//imageScaleMethod: 图片缩放方法(模式).可选值: "fit", "fitNoUpscale" 和 "zoom".模式"fit" 保证图像适应屏幕. "fitNoUpscale" 和 "fit"类似但是不会放大图片. "zoom"将图片全屏, 但有可能图片缩放不是等比例的.默认 = "fit"
//invertMouseWheel: 反转鼠标滚轮。默认情况下, 鼠标向下滚动将切换到下一张, 向上切换到上一张.默认 = false
//jQueryMobile: 指示 PhotoSwipe 是否集成进了 jQuery Mobile 项目.默认情况下, PhotoSwipe will try and work this out for you
//jQueryMobileDialogHash: jQuery Mobile的window, dialog页面 所使用的hash标签。 默认值 = "&ui-state=dialog"
//loop: 相册是否自动循环.默认 = true
//margin: 两张图之间的间隔, 单位是像素.默认 = 20
//maxUserZoom: 最大放大倍数.默认 = 5.0(设置为0将被忽略)
//minUserZoom: 图像最小的缩小倍数.默认 = 0.5(设置为0将会忽略)
//mouseWheelSpeed: 响应鼠标滚轮的灵敏度.默认 = 500(毫秒)
//nextPreviousSlideSpeed: 当点击上一张, 下一张按钮后, 延迟多少毫秒执行切换.默认 = 0(立即切换)
//preventHide: 阻止用户关闭 PhotoSwipe.同时也会隐藏 工具栏上的"close"关闭按钮.在独享的页面使用(示例是源码中的 examples / 08 - exclusive - mode.html).默认 = false
//preventSlideshow: 阻止自动播放模式.同时也会隐藏工具栏里的播放按钮.默认 = false
//slideshowDelay: 自动播放模式下，多长时间播放下一张.Default = 3000(毫秒)
//slideSpeed: 图片滑进视图的时间.默认 = 250(毫秒)
//swipeThreshold: 手指滑动多少像素才触发一个  swipe 手势事件.默认 = 50
//swipeTimeThreshold: 定义触发swipe(滑动)手势的最大毫秒数, 太慢了则不会触发滑动，只会拖动当前照片的位置.默认 = 250
//slideTimingFunction: 滑动时的 Easing function .默认 = "ease-out"
//zIndex: 初始的zIndex值.默认 = 1000
//enableUIWebViewRepositionTimeout: 检查设备的方向是否改变。默认 = false
//uiWebViewResetPositionDelay: 定时检查设备的方向是否改变的时间 默认 = 500(毫秒)
//preventDefaultTouchEvents: 阻止默认的touch事件，比如页面滚动。 默认 = true
//target: 必须是一个合法的DOM元素(如DIV) 。默认是window(全页面) 。而如果是某个低级别的DOM，则在DOM内显示，可能非全屏。


//API方法
//PhotoSwipe也提供了许多方法调用，以下方法有可能你会用得到：
//var pswp = new PhotoSwipe( /* ... */);
//pswp.init(); //初始化
//pswp.goTo(index); //跳到第几张图
//pswp.next(); //下一张
//pswp.prev(); //上一张
//pswp.close(); //关闭图集
//pswp.destroy(); //关闭图集后销毁图集
//// 动态添加图片
//pswp.items.push({
//    src: "path/to/image.jpg",
//    w: 1200,
//    h: 500
//});