﻿// 公共函数
; bzw315_utils_validate = {
    func: function () {
        // 正则 - 金额
        this.CheckMoney = function (money) {
            var moneyReg = /^[1-9](\d+)?(\.\d{1,2})?$/;
            if (moneyReg.test(money)) {
                return true;
            }
            return false;
        };

        // 正则 - 正整数
        this.CheckNum = function (number) {
            var numReg = /^\+?[1-9][0-9]*$/;
            if (numReg.test(number)) {
                return true;
            }
            return false;
        };

        // 正则 - 手机
        this.CheckPhone = function (mobile) {
            var mobileReg = /^(13|14|15|16|17|18|19)\d{9}$/;
            if (mobileReg.test(mobile)) {
                return true;
            }
            return false;
        };

        // 正则 - 固定电话[带区号、分机号验证]
        this.CheckLocalPhone = function (mobile) {
            var phoneReg = /^(?:(?:0\d{2,3})-)?(?:\d{7,8})(-(?:\d{3,}))?$/;
            if (phoneReg.test(mobile)) {
                return true;
            }
            return false;
        };

        // 正则 - 邮箱
        this.CheckEmail = function (email) {
            var emailReg = /^[a-z0-9]+([._\\-]*[a-z0-9])*@([a-z0-9]+[-a-z0-9]*[a-z0-9]+.){1,63}[a-z0-9]+$/;
            if (emailReg.test(email)) {
                return true;
            }
            return false;
        }
    }
}