﻿function ajaxSubmitForm(func) {
    var form = $("form");
    if (form.length > 0) {
        var url = form.attr("action");
        var option = {
            url: url,
            type: 'POST',
            dataType: 'json',
            headers: { "ClientCallMode": "ajax" }, //添加请求头部
            beforeSubmit: function () {
                $("#div_message").html("");

                $.blockUI({ message: '<h1>正在导入，请稍后。。。</h1>' });
            },
            beforeSend: function () { },
            uploadProgress: function (event, position, total, percentComplete) { },
            success: function (data) {
                $.unblockUI();

                func(data);
            },
            error: function (data) {
                $.unblockUI();
                func(data);
            }
        };
        $("form").ajaxSubmit(option);
        return false; //最好返回false，因为如果按钮类型是submit,则表单自己又会提交一次;返回false阻止表单再次提交
    }
};

function myImport() {
    if ($("#myfile").val() == "") {
        alert("请选择导入的文件");
        return false;
    }

    if (confirm("确认导入？")) {
        ajaxSubmitForm(function (data) {
            if (data.message == "") {
                ReturnUrl();
            }
            else {
                $("#div_message").html(data.message).show();
            }
        });
    }
};