﻿<%@ WebHandler Language="C#" Class="AD_Book_Ajax" %>

using System;
using System.Web;
using OE_BLL;
using System.Data;
using Jayrock.Json;
public class AD_Book_Ajax : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        HttpRequest Request = context.Request;
        HttpResponse Response = context.Response;

        Guid key = Guid.Empty;
        if (Request["t_id"] != null)
        {
            key = new Guid(Request["t_id"].ToString());
        }

        N25175_Book_BLL bll = new N25175_Book_BLL();

        DataTable data = bll.GetOption(key);

        JsonArray json = new JsonArray();

        foreach (DataRow row in data.Rows)
        {
            JsonObject item = new JsonObject();
            item.Accumulate("id", row["b_id"].ToString());
            item.Accumulate("name", row["b_name"].ToString());
            json.Add(item);
        }

        Response.Write(json);
        Response.End();
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}