﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;

public partial class Admin_Paper_AddPaperByRandomSelection : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            PaperByRandomSelection paper = new PaperByRandomSelection();
            paper.JudgeSum = Convert.ToInt32(txtJudgeSum.Text);
            paper.SingleSelectionSum = Convert.ToInt32(txtSingleSelectionSum.Text);
            paper.MultiSelectionSum = Convert.ToInt32(txtMultiSelectionSum.Text);
            paper.PaperName = txtPaperName.Text;
            paper.PaperType.DeptID = Convert.ToInt16(drlDeptList.SelectedValue);
            paper.PaperType.DeptName = drlDeptList.SelectedItem.Text;
            paper.Creator = SessionClass.GetLoginUser();
            paper.CreatedTime = DateTime.Now;
            paper.JudgeCateID = Convert.ToInt32(drpSubjectTypeCategory1.SelectedValue);
            paper.SingleSelectionCateID = Convert.ToInt32(drpSubjectTypeCategory2.SelectedValue);
            paper.MultiSelectionCateID = Convert.ToInt32(drpSubjectTypeCategory3.SelectedValue);

            if (paper.JudgeSum > Convert.ToInt32(Label1.Text))
            {
                lblMsg.Text = "判断题数量不能超过" + Label1.Text + "题";
                return;
            }

            if (paper.SingleSelectionSum > Convert.ToInt32(Label2.Text))
            {
                lblMsg.Text = "单选题数量不能超过" + Label2.Text + "题";
                return;
            }
            if (paper.MultiSelectionSum > Convert.ToInt32(Label3.Text))
            {
                lblMsg.Text = "多选题数量不能超过" + Label3.Text + "题";
                return;
            }
            new BLLPaperByRandomSelection().CreatePaper(paper);
            Response.Redirect("PaperByRandomSelectionList.aspx");
        }
        catch (BLLException ex)
        {
            lblMsg.Text = ex.Msg;
        }
        catch (Exception ex)
        {
            lblMsg.Text = ex.Message;
        }
        
    }
    protected void drpSubjectTypeCategory1_SelectedIndexChanged(object sender, EventArgs e)
    {
        Label1.Text = new BLLSubjectOfJudge().GetSubjectCount(Convert.ToInt32(drpSubjectTypeCategory1.SelectedValue)).ToString();
    }
    protected void drpSubjectTypeCategory2_SelectedIndexChanged(object sender, EventArgs e)
    {
        Label2.Text = new BLLSubjectOfSingleSelection().GetSubjectCount(Convert.ToInt32(drpSubjectTypeCategory2.SelectedValue)).ToString();
    }
    protected void drpSubjectTypeCategory3_SelectedIndexChanged(object sender, EventArgs e)
    {
        Label3.Text = new BLLSubjectOfMultiSelection().GetSubjectCount(Convert.ToInt32(drpSubjectTypeCategory3.SelectedValue)).ToString();
    }
}
