﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Entity;
using BLL;

public partial class Admin_Paper_ModPaper : System.Web.UI.Page
{
    
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            Paper paper = new BLLPaper().GetPaperByID(paperID);
            if (paper != null)
                BindPaperInfo(paper);

        }
    }

    private string paperType;

    private string paperID
    {
        get
        {
            if(string.IsNullOrEmpty(hdfPaperID.Value))
                hdfPaperID.Value = Request.QueryString["paperID"];

            return hdfPaperID.Value;
        }
    }

    private void BindPaperInfo(Paper paper)
    {
        txtPaperName.Text = paper.PaperName;
        this.paperType = paper.PaperType.DeptName;
        ftbPaperContent.Text = paper.Content;
        ftbPaperAnswer.Text = paper.Answer;
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            Paper paper = new Paper();
            paper.PaperID = Convert.ToInt32(paperID);
            paper.PaperName = txtPaperName.Text;
            paper.PaperType.DeptID = Convert.ToInt16(drlDeptList.SelectedValue);
            paper.PaperType.DeptName = drlDeptList.SelectedItem.Text;
            paper.Content = ftbPaperContent.Text;
            paper.Answer = ftbPaperAnswer.Text;
            paper.Creator.Name = SessionClass.GetLoginUser().Name;
            new BLLPaper().ModifyPaper(paper);
            Response.Redirect("paperList.aspx");
        }
        catch
        {
            lblMsg.Text = "保存失败，请检查输入并重试！";
        }

    }

    protected void lbtnPreviewPaper_Click(object sender, EventArgs e)
    {
        SessionClass.SetPaperTilte(txtPaperName.Text);
        SessionClass.SetPaperContent(ftbPaperContent.Text);

        Tool.JscriptHelper.OpenNewPage("PreviewPaper.aspx", "预览试卷");
    }


    protected void drlDeptList_DataBound(object sender, EventArgs e)
    {
        for (int i = 0; i < drlDeptList.Items.Count; i++)
        {
            if (drlDeptList.Items[i].Text.Equals(this.paperType))
                drlDeptList.SelectedIndex = i;
        }
    }
}
