﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;

public partial class Admin_Paper_PaperByRandomSelectionDetail : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
            BindPaperInfo();
    }
    private int paperID
    {
        get
        {
            int id = 0;
            if (Int32.TryParse(Request.QueryString["paperID"], out id))
                return id;
            else
                return -1;
        }
    }


    private void BindPaperInfo()
    {
        if (paperID < 0)
            return;

        PaperByRandomSelection paper = new BLLPaperByRandomSelection().GetPaper(paperID);
        if (paper != null)
        {
            rptSubjectOfJudgeList.DataSource = paper.JudgeList;
            rptSubjectOfJudgeList.DataBind();
            lblJudgeListCount.Text = paper.JudgeList.Count.ToString();

            rptSubjectOfSingleSelectionList.DataSource = paper.SingleSelectionList;
            rptSubjectOfSingleSelectionList.DataBind();
            lblSingleSelectionCount.Text = paper.SingleSelectionList.Count.ToString();

            rptSubjectOfMultiSelectionList.DataSource = paper.MultiSelectionList;
            rptSubjectOfMultiSelectionList.DataBind();
            lblMultiSelectionCount.Text = paper.MultiSelectionList.Count.ToString();

            lblPaperName.Text = paper.PaperName;
            lblPaperType.Text = paper.PaperType.DeptName;
        }

    }
}
