﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Entity;
using BLL;
using Tool;

public partial class Admin_Paper_PaperList : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            int pageNum = 1;
            if (Request.QueryString["pageNum"] != null)
                pageNum = Convert.ToInt32(Request.QueryString["pageNum"]);
            BindPaperList(pageNum);
        }
    }

    private const int PAGE_SIZE = 20;
    private void BindPaperList(int pageNum)
    {
        PageList<Paper> list = new BLLPaper().GetPaperList(pageNum, PAGE_SIZE);
        Repeater1.DataSource = list.RecorderList;
        Repeater1.DataBind();
        lblPageUrl.Text = StringHelper.MakePageUrl("?pageNum=", pageNum, list.PageCount, list.RecorderCount);
    }
}
