﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using Entity;
using BLL;

public partial class Admin_Subject_AddSubjectTypeCategory : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            DropDownList1.SelectedValue = ((int)subjectType).ToString();
            txtCateName.Focus();
        }
    }

    private SubjectType subjectType
    {
        get { return (SubjectType)Helper.GetUrlParmValue("subjectType"); }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        SubjectTypeCategory category = new SubjectTypeCategory();
        category.SubjectType = (SubjectType)Convert.ToInt32(DropDownList1.SelectedValue);
        category.CateName = txtCateName.Text;
        new BLLSubjectTypeCategory().Create(category);

        switch (category.SubjectType)
        {
            case SubjectType.FillBlank:
                Response.Redirect("AddSubjectOfFillBlank.aspx");
                break;
            case SubjectType.Judge:
                Response.Redirect("AddSubjectOfJudge.aspx");
                break;
            case SubjectType.SingleSelection:
                Response.Redirect("AddSubjectOfSingleSelection.aspx");
                break;
            case SubjectType.MultiSelection:
                Response.Redirect("AddSubjectOfMultiSelection.aspx");
                break;
            case SubjectType.SimpleAnswer:
                Response.Redirect("AddSubjectOfSimpleAnswer.aspx");
                break;
        }
    }
}
