﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using BLL;
using Entity;
using Tool;

public partial class Admin_System_AddUser : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            txtUserID.Focus();
        }
    }
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        //----------验证信息
        if (drlDeptList.SelectedIndex == 0)
        {
            lblMsg.Text = "请选择部门！";
            return;
        }

        bool hasSelectRight = false;
        for (int i = 0; i < cblRight.Items.Count; i++)
            if (cblRight.Items[i].Selected)
            {
                hasSelectRight = true;
                break;
            }
        if (!hasSelectRight)
        {
            lblMsg.Text = "请选择权限！";
            return;
        }

        BLLAdmin bllAdmin = new BLLAdmin();
        if (bllAdmin.CheckUserIDIsExist(txtUserID.Text))
        {
            lblMsg.Text = "该用户账号已存在！";
            return;
        }

        Entity.User user = new User();
        user.UserID = txtUserID.Text;
        user.Name = txtName.Text;
        user.UserPwd =cbDefaultPwd.Checked ? "123456": txtPwd.Value;
        user.Department.DeptID = Convert.ToInt16(drlDeptList.SelectedItem.Value);

        List<string> rightList = new List<string>();
        for (int i = 0; i < cblRight.Items.Count; i++)
            if (cblRight.Items[i].Selected)
                rightList.Add(cblRight.Items[i].Text);
        
        user.RightList = rightList;

        user.Locked = rblLocked.SelectedIndex == 0 ? true : false;
        user.LastLoginIP =string.Empty;
        user.CreatedTime = DateTime.Now;

        bllAdmin.CreateUser(user);
        Server.Transfer("userList.aspx");

    }
}
