﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Entity;
using BLL;

public partial class Admin_System_ModDepartment : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
            BindDeptInfo();
    }

    private string deptID
    {
        get
        {
            return Request.QueryString["deptID"];
        }
    }

    private void BindDeptInfo()
    {
        hfdDeptID.Value = deptID;
        Department dept = new BLLDepartment().GetDeptByID(deptID);

        if (dept != null)
        {
            txtDeptName.Text = dept.DeptName;
            this.Title ="修改: "+ dept.DeptName;
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            Department dept = new Department();
            dept.DeptID = Convert.ToInt16(hfdDeptID.Value);
            dept.DeptName = txtDeptName.Text;

            new BLLDepartment().ModifyDept(dept);

            Response.Redirect("DepartmentList.aspx");
        }
        catch
        {
            lblMsg.Text = "保存失败，请检查输入并重试！";
        }
    }
}
