﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;

using Entity;
using BLL;

public partial class Admin_Test_AddTest : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            switch(paperType)
            {
                case  PaperType.ByInput:
                 linkViewPaper.NavigateUrl = "../Paper/PaperDetail.aspx?paperID=" + paperID;
                    break;
                case PaperType.BySelection:
                    {
                        linkViewPaper.NavigateUrl = "../Paper/PaperByManualSelectionDetail.aspx?paperID=" + paperID;
                        txtTotalScores.Text = SessionClass.GetTotalScores().ToString();
                        txtPassScores.Text = ((int)(SessionClass.GetTotalScores() * 0.6)).ToString();
                        txtTestName.Text = SessionClass.GetPaperTitle();

                        SessionClass.SetTotalScores(0);
                        SessionClass.SetPaperTilte(null);
                    }
                    break;
                case PaperType.ByRandom:
                    {
                        linkViewPaper.NavigateUrl = "../Paper/PaperByRandomSelectionDetail.aspx?paperID=" + paperID;
                        txtTotalScores.Text = SessionClass.GetTotalScores().ToString();
                        txtPassScores.Text = ((int)(SessionClass.GetTotalScores() * 0.6)).ToString();
                        txtTestName.Text = SessionClass.GetPaperTitle();

                        SessionClass.SetTotalScores(0);
                        SessionClass.SetPaperTilte(null);
                    }
                    break;
                default:
                    break;

            }
            DateTime now = DateTime.Now;
            txtEnableDate.Text = now.ToShortDateString();
            txtUnableDate.Text = now.ToShortDateString();
        }
    }

    private PaperType paperType
    {
        get
        {
            int type = 0;
            try
            {
                type = Convert.ToInt32(Request.QueryString["paperType"]);
            }
            catch
            {
                Response.Redirect("~/error/error.aspx?msg="+"paperType参数错误！");
            }
            switch (type)
            {
                case 1:
                    return PaperType.BySelection;
                case 2:
                    return PaperType.ByRandom;
                case 3:
                    return PaperType.ByInput;
                default:
                    return PaperType.BySelection;
            }
        }
    }

    private int paperID
    {
        get
        {
            int id=0;
            try
            {
                id = Convert.ToInt32(Request.QueryString["paperID"]);
            }
            catch
            {
                Response.Redirect("~/error/error.aspx?msg=" + "paperID参数错误！");
            }
            return id;
        }
    }


    protected void objdsDeptList_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        List<Department> deptList = (List<Department>)e.ReturnValue;
        if (null != deptList)
        {
            lblDeptCount2.Text = deptList.Count.ToString();
        }
    }


    protected void lbxDeptList2_SelectedIndexChanged(object sender, EventArgs e)
    {
        int deptID = Convert.ToInt32(lbxDeptList2.SelectedValue);
        string deptName = lbxDeptList2.SelectedItem.Text;

        List<Entity.User> userList = new BLLAdmin().GetUserListByDeptID(deptID);
        foreach (Entity.User user in userList)
        {
            user.Name = user.Name + "(" + deptName + ")";
        }

        lbxUserList.DataSource = userList;
        lbxUserList.DataBind();
        lblUserCount.Text = userList.Count.ToString();
    }

    private void AddUser(Entity.User user)
    {
        for (int i = 0; i < lbxUserListSelected.Items.Count; i++)
        {
            if (user.UserID.Equals(lbxUserListSelected.Items[i].Value))
                return;
        }
        ListItem item = new ListItem(user.Name, user.UserID);
        lbxUserListSelected.Items.Add(item);
        lblUserSelectedCount.Text = lbxUserListSelected.Items.Count.ToString();
    }

    private void RemoveUser(ListItem item)
    {
        lbxUserListSelected.Items.Remove(item);
        lblUserSelectedCount.Text = lbxUserListSelected.Items.Count.ToString();
    }

    protected void btnAddSelected_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < lbxUserList.Items.Count; i++)
        {
            if (lbxUserList.Items[i].Selected)
            {
                Entity.User user = new User();
                user.UserID = lbxUserList.SelectedValue;
                user.Name = lbxUserList.SelectedItem.Text;

                AddUser(user);
            }
        }
    }

    protected void btnAddAll_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < lbxUserList.Items.Count; i++)
        {

            Entity.User user = new User();
            user.UserID = lbxUserList.Items[i].Value;
            user.Name = lbxUserList.Items[i].Text;

            AddUser(user);
        }
    }

    protected void btnDelSelected_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < lbxUserListSelected.Items.Count; i++)
        {
            if (lbxUserListSelected.Items[i].Selected)
            {
                ListItem item= lbxUserListSelected.Items[i];

                RemoveUser(item);
            }
        }
    }

    protected void btnDelAll_Click(object sender, EventArgs e)
    {
        lbxUserListSelected.Items.Clear();
    }

    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        try
        {
            Test test = new Test();
            test.TestName = txtTestName.Text;
            test.PaperType = paperType;
            test.Paper.PaperID = paperID;
            test.TotalScores = Convert.ToInt32(txtTotalScores.Text);
            test.PassScores = Convert.ToInt32(txtPassScores.Text);
            test.NeededMinutes = Convert.ToInt16(txtNeededMinutes.Text);
            test.EnableDate = Convert.ToDateTime(txtEnableDate.Text);
            test.UnabaleDate = Convert.ToDateTime(txtUnableDate.Text);
            test.AutoSaveInterval = Convert.ToInt16(txtAutoSaveInterval.Text);
            test.Creator = SessionClass.GetLoginUser();
            test.CreatedTime = DateTime.Now;

            foreach (ListItem item in lbxUserListSelected.Items)
            {
                Tester tester = new Tester();
                tester.UserID = item.Value;
                test.TesterList.Add(tester);

            }

            BLLTest bllTest = new BLLTest();
            switch(paperType)
            {
                case PaperType.ByInput:
                    bllTest.CreateTest(test);
                    break;
                case PaperType.BySelection:
                    {
                        bllTest.CreateTest(test,
                             SessionClass.GetFillBlankScoresOfEveryone(),
                             SessionClass.GetJudgeScoresOfEveryone(),
                             SessionClass.GetSingleSelectionScoresOfEveryone(),
                             SessionClass.GetMultiSelectionScoresOfEveryone(),
                             SessionClass.GetSimpleAnswerScores());
                        break;
                    }
                case PaperType.ByRandom:
                    {
                        bllTest.CreateTest(test,
                            0,
                            SessionClass.GetJudgeScoresOfEveryone(),
                            SessionClass.GetSingleSelectionScoresOfEveryone(),
                            SessionClass.GetMultiSelectionScoresOfEveryone(),
                            null);
                        break;
                    }
                default:
                    break;
            }
            Response.Redirect("testList.aspx");
        }
        catch (Exception ex)
        {
            lblMsg.Text = ex.Message;
        }
    }


}
