﻿using System;
using System.Data;
using System.Configuration;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Entity;
using BLL;

public partial class Admin_Test_ModTest : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindTestInfo();
            BindTesterSelectedInfo();
        }
    }

    private string testID
    {
        get
        {
            if(string.IsNullOrEmpty(hdfTestID.Value))
                hdfTestID.Value= Request.QueryString["testID"];

            return hdfTestID.Value;
        }
    }

    //绑定考试信息
    private void BindTestInfo()
    {
        Test test = new BLLTest().GetTestByID(testID);
        if (test != null)
        {
            txtTestName.Text = test.TestName;
            txtNeededMinutes.Text = test.NeededMinutes.ToString();
            txtEnableDate.Text = test.EnableDate.ToShortDateString();
            txtUnableDate.Text = test.UnabaleDate.ToShortDateString();
            txtAutoSaveInterval.Text = test.AutoSaveInterval.ToString();
        }
    }

    //绑定考试人员
    private void BindTesterSelectedInfo()
    {
        List<Entity.User> userList = new BLLAdmin().GetTesterByTestID(testID);

        foreach (Entity.User user in userList)
        {
            user.Name = user.Name + "(" + user.Department.DeptName + ")";
            AddUser(user);
        }

    }

    private void AddUser(Entity.User user)
    {
        for (int i = 0; i < lbxUserListSelected.Items.Count; i++)
        {
            if (user.UserID.Equals(lbxUserListSelected.Items[i].Value))
                return;
        }
        ListItem item = new ListItem(user.Name, user.UserID);
        lbxUserListSelected.Items.Add(item);
        lblUserSelectedCount.Text = lbxUserListSelected.Items.Count.ToString();
    }

    private void RemoveUser(ListItem item)
    {
        lbxUserListSelected.Items.Remove(item);
        lblUserSelectedCount.Text = lbxUserListSelected.Items.Count.ToString();
    }

    protected void lbxDeptList2_SelectedIndexChanged(object sender, EventArgs e)
    {
        int deptID = Convert.ToInt32(lbxDeptList2.SelectedValue);
        string deptName = lbxDeptList2.SelectedItem.Text;

        List<Entity.User> userList = new BLLAdmin().GetUserListByDeptID(deptID);
        foreach (Entity.User user in userList)
        {
            user.Name = user.Name + "(" + deptName + ")";
        }

        lbxUserList.DataSource = userList;
        lbxUserList.DataBind();
        lblUserCount.Text = userList.Count.ToString();
    }

    protected void objdsDeptList_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        List<Department> deptList = (List<Department>)e.ReturnValue;
        if (null != deptList)
        {
            lblDeptCount2.Text = deptList.Count.ToString();
        }
    }

    protected void btnAddSelected_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < lbxUserList.Items.Count; i++)
        {
            if (lbxUserList.Items[i].Selected)
            {
                Entity.User user = new User();
                user.UserID = lbxUserList.SelectedValue;
                user.Name = lbxUserList.SelectedItem.Text;

                AddUser(user);
            }
        }
    }

    protected void btnAddAll_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < lbxUserList.Items.Count; i++)
        {

            Entity.User user = new User();
            user.UserID = lbxUserList.Items[i].Value;
            user.Name = lbxUserList.Items[i].Text;

            AddUser(user);
        }
    }

    protected void btnDelSelected_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < lbxUserListSelected.Items.Count; i++)
        {
            if (lbxUserListSelected.Items[i].Selected)
            {
                ListItem item = lbxUserListSelected.Items[i];

                RemoveUser(item);
            }
        }
    }

    protected void btnDelAll_Click(object sender, EventArgs e)
    {
        lbxUserListSelected.Items.Clear();
    }


    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {

            Test test = new Test();
            test.TestID =Convert.ToInt32(testID);
            test.TestName = txtTestName.Text;
            test.NeededMinutes = Convert.ToInt16(txtNeededMinutes.Text);
            test.EnableDate = Convert.ToDateTime(txtEnableDate.Text);
            test.UnabaleDate = Convert.ToDateTime(txtUnableDate.Text);
            test.AutoSaveInterval = Convert.ToInt16(txtAutoSaveInterval.Text);
            test.CreatedTime = DateTime.Now;

            foreach (ListItem item in lbxUserListSelected.Items)
            {
                Tester tester = new Tester();
                tester.UserID = item.Value;
                test.TesterList.Add(tester);

            }

            BLLTest bllTest = new BLLTest();
            bllTest.ModifyTest(test);
            Response.Redirect("testList.aspx");
        }
        catch (Exception ex)
        {
            lblMsg.Text = ex.Message;
        }
    }
}
