﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using System.Collections.Generic;

using Entity;
using BLL;

public partial class Admin_Test_SetScores : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
            BindPaperInfo();
    }
    private int paperID
    {
        get
        {
            int id = 0;
            if (Int32.TryParse(Request.QueryString["paperID"], out id))
                return id;
            else
                return -1;
        }
    }
    private void BindPaperInfo()
    {
        if (paperID < 0)
            return;

        PaperByManualSelection paper = new BLLPaperByManuaSelection().GetPaper(paperID);
        if (paper != null)
        {
            rptSubjectOfFillBlankList.DataSource = paper.FillBlankList;
            rptSubjectOfFillBlankList.DataBind();
            lblFillBlankListCount.Text = paper.FillBlankList.Count.ToString();
            if (paper.FillBlankList.Count > 0)
                Label1.Visible = false;

            rptSubjectOfJudgeList.DataSource = paper.JudgeList;
            rptSubjectOfJudgeList.DataBind();
            lblJudgeListCount.Text = paper.JudgeList.Count.ToString();
            if (paper.JudgeList.Count > 0)
                Label2.Visible = false;

            rptSubjectOfSingleSelectionList.DataSource = paper.SingleSelectionList;
            rptSubjectOfSingleSelectionList.DataBind();
            lblSingleSelectionCount.Text = paper.SingleSelectionList.Count.ToString();
            if (paper.SingleSelectionList.Count > 0)
                Label3.Visible = false;

            rptSubjectOfMultiSelectionList.DataSource = paper.MultiSelectionList;
            rptSubjectOfMultiSelectionList.DataBind();
            lblMultiSelectionCount.Text = paper.MultiSelectionList.Count.ToString();
            if (paper.MultiSelectionList.Count > 0)
                Label4.Visible = false;

            rptSubjectOfSimpleAnswerList.DataSource = paper.SimpleAnswerList;
            rptSubjectOfSimpleAnswerList.DataBind();
            lblSimpleAnswerCount.Text = paper.SimpleAnswerList.Count.ToString();
            if (paper.SimpleAnswerList.Count > 0)
                Label5.Visible = false;

            lblPaperName.Text = paper.PaperName;
            lblPaperType.Text = paper.PaperType.DeptName;
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        int fillBlankScores = 0;
        int judgeScores = 0;
        int singleSelectionScores = 0;
        int multiSelectionScores = 0;
        try
        {
            fillBlankScores = Convert.ToInt32(txtFillBlankScores.Text);
        }
        catch { }
        try
        {
            judgeScores = Convert.ToInt32(txtJudgeScores.Text);
        }
        catch { }

        try
        {
            singleSelectionScores = Convert.ToInt32(txtSingleSelectionScores.Text);
        }
        catch { }
        try
        {
            multiSelectionScores = Convert.ToInt32(txtMultiSelectionScores.Text);
        }
        catch { }

        //简答题，每题的分数不一定一样
        List<SubjectOfSimpleAnswer> list = new List<SubjectOfSimpleAnswer>();
        for (int i = 0; i < rptSubjectOfSimpleAnswerList.Items.Count; i++)
        {
            HiddenField hidID = (HiddenField)rptSubjectOfSimpleAnswerList.Items[i].FindControl("hidSimpleAnswerID");
            int id = Convert.ToInt32(hidID.Value);
            TextBox txtScores = (TextBox)rptSubjectOfSimpleAnswerList.Items[i].FindControl("txtSimpleAnswerScores");
            int scores = Convert.ToInt32(txtScores.Text);

            SubjectOfSimpleAnswer subject = new SubjectOfSimpleAnswer();
            subject.Id = id;
            subject.Scores = scores;

            list.Add(subject);
        }

        int totalScores = Convert.ToInt32(txtTotalScores.Text);

        SessionClass.SetFillBlankScoresOfEveryone(fillBlankScores);
        SessionClass.SetJudgeScoresOfEveryone(judgeScores);
        SessionClass.SetSingleSelectionScoresOfEveryone(singleSelectionScores);
        SessionClass.SetMultiSelectionScoresOfEveryone(multiSelectionScores);
        SessionClass.SetSimpleAnswerScores(list);
        SessionClass.SetTotalScores(totalScores);

        SessionClass.SetPaperTilte(lblPaperName.Text);
        Response.Redirect("addTest.aspx?paperType=1&paperID="+paperID);
    }
}

