﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Entity;
using BLL;
using Tool;

public partial class Admin_Test_TestList : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            int pageNum = 1;
            if (Request.QueryString["pageNum"] != null)
                pageNum = Convert.ToInt32(Request.QueryString["pageNum"]);
            BindTestList(pageNum);
        }
    }

    private const int PAGE_SIZE =20;
    private void BindTestList(int pageNum)
    {
        PageList<Test> list = new BLLTest().GetTestList(pageNum, PAGE_SIZE);
        rplTestList.DataSource = list.RecorderList;
        rplTestList.DataBind();
        lblPageUrl.Text = StringHelper.MakePageUrl("?pageNum=", pageNum, list.PageCount, list.RecorderCount);
    }

    protected void rplTestList_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType==ListItemType.AlternatingItem)
        {
            HiddenField hidPaperType = (HiddenField)e.Item.FindControl("hidPaperType");
            HiddenField hidTestID = (HiddenField)e.Item.FindControl("hidTestID");
            HiddenField hidPaperID = (HiddenField)e.Item.FindControl("hidPaperID");
            HyperLink link = (HyperLink)e.Item.FindControl("HyperLink1");
            
             string url=string.Empty;
             int paperType = Convert.ToInt32(hidPaperType.Value);
             switch ((PaperType)paperType)
             {
                 case PaperType.BySelection:
                     url = "~/Admin/Test/PaperByManualSelectionDetail.aspx";
                     break;
                 case PaperType.ByRandom:
                     url = "~/Admin/Test/PaperByRandomSelectionDetail.aspx";
                     break;
                 case PaperType.ByInput:
                     url = "~/Admin/Paper/PaperDetail.aspx";
                     break;
                 default:
                     break;
             }
             link.NavigateUrl = url + string.Format("?testID={0}&paperID={1}", hidTestID.Value, hidPaperID.Value);
        }
    }

}
