﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using Entity;

/// <summary>
/// SessionClass 的摘要说明
/// </summary>
public class SessionClass
{
    public SessionClass()
    {
    }
    public static Entity.User GetLoginUser()
    {
        if (null == HttpContext.Current.Session["loginUser"])
            return null;
        return (Entity.User)Tool.SerializeHelper.DeserializeObject(HttpContext.Current.Session["loginUser"].ToString());
    }

    public static void SetLoinUser(Entity.User loginUser)
    {
        if(loginUser!=null)
            HttpContext.Current.Session["loginUser"] =Tool.SerializeHelper.SerializeObject(loginUser);
    }

    
    public static string GetPaperContent()
    {
        object obj= HttpContext.Current.Session["PaperContent"];

        return obj==null ? string.Empty : obj.ToString();
    }

    public static void SetPaperContent(string content)
    {
        HttpContext.Current.Session["PaperContent"] = content;
    }

    public static string GetPaperTitle()
    {
        object obj = HttpContext.Current.Session["PaperTitle"];
        return obj == null ? string.Empty : obj.ToString();
    }

    public static void SetPaperTilte(string title)
    {
        HttpContext.Current.Session["PaperTitle"] = title;
    }


    public static void SetAlertMsg(string alertMsg)
    {
        HttpContext.Current.Session["AlertMsg"] = alertMsg;
    }

    public static string GetAlertMsg()
    {
        object obj = HttpContext.Current.Session["AlertMsg"] ;
        return obj == null ? string.Empty : obj.ToString();
    }

    #region 手工选题相关
    public static void SetFillBlankList(List<SubjectOfFillBlank> subjectList)
    {
        if (subjectList == null)
        {
            HttpContext.Current.Session["fillBlankList"] = null;
            return;
        }
         HttpContext.Current.Session["fillBlankList"] =Tool.SerializeHelper.SerializeObject(subjectList);
    }
    public static List<SubjectOfFillBlank> GetFillBlankList()
    {
        if (null == HttpContext.Current.Session["fillBlankList"])
            return null;
        return (List<SubjectOfFillBlank>)Tool.SerializeHelper.DeserializeObject(HttpContext.Current.Session["fillBlankList"].ToString());
    }

    public static void SetJudgeList(List<SubjectOfJudge> subjectList)
    {
        if (subjectList == null)
        {
            HttpContext.Current.Session["judgeList"] = null;
            return;
        }
        HttpContext.Current.Session["judgeList"]=Tool.SerializeHelper.SerializeObject(subjectList);
    }
    public static List<SubjectOfJudge> GetJudgeList()
    {
        if (null == HttpContext.Current.Session["judgeList"])
            return null;
        return (List<SubjectOfJudge>)Tool.SerializeHelper.DeserializeObject(HttpContext.Current.Session["judgeList"].ToString());
    }

    public static void SetSingleSelection(List<SubjectOfSingleSelection> subjectList)
    {
        if (subjectList == null)
        {
            HttpContext.Current.Session["singleSelectionList"] = null;
            return;
        }
        HttpContext.Current.Session["singleSelectionList"] = Tool.SerializeHelper.SerializeObject(subjectList);
    }
    public static List<SubjectOfSingleSelection> GetSingleSelection()
    {
        if (null == HttpContext.Current.Session["singleSelectionList"])
            return null;
        return (List<SubjectOfSingleSelection>)Tool.SerializeHelper.DeserializeObject(HttpContext.Current.Session["singleSelectionList"].ToString());
    }

    public static void SetMultiSelection(List<SubjectOfMultiSelection> subjectList)
    {
        if (subjectList == null)
        {
            HttpContext.Current.Session["multiSelectionList"] = null;
            return;
        }
        HttpContext.Current.Session["multiSelectionList"] = Tool.SerializeHelper.SerializeObject(subjectList);
    }
    public static List<SubjectOfMultiSelection> GetMultiSelection()
    {
        if (null == HttpContext.Current.Session["multiSelectionList"])
            return null;
        return (List<SubjectOfMultiSelection>)Tool.SerializeHelper.DeserializeObject(HttpContext.Current.Session["multiSelectionList"].ToString());
    }

    public static void SetSimpleAnswer(List<SubjectOfSimpleAnswer> subjectList)
    {
        if (subjectList == null)
        {
            HttpContext.Current.Session["simpleAnswer"] = null;
            return;
        }
        HttpContext.Current.Session["simpleAnswer"] = Tool.SerializeHelper.SerializeObject(subjectList);
    }
    public static List<SubjectOfSimpleAnswer> GetSimpleAnswer()
    {
        if (null == HttpContext.Current.Session["simpleAnswer"])
            return null;
        return (List<SubjectOfSimpleAnswer>)Tool.SerializeHelper.DeserializeObject(HttpContext.Current.Session["simpleAnswer"].ToString());
    }
    #endregion

    #region 分配分数相关
    public static void SetTotalScores(int scores)
    {
        HttpContext.Current.Session["totalScores"] = scores;
    }
    public static int GetTotalScores()
    {
        if (HttpContext.Current.Session["totalScores"] == null)
            return 0;
        return Convert.ToInt32(HttpContext.Current.Session["totalScores"]);
    }

    public static void SetFillBlankScoresOfEveryone(int scores)
    {
        HttpContext.Current.Session["fillBlankScores"] = scores;
    }
    public static int GetFillBlankScoresOfEveryone()
    {
        if (HttpContext.Current.Session["fillBlankScores"] == null)
            return 0;
        return Convert.ToInt32(HttpContext.Current.Session["fillBlankScores"]);
    }

    public static void SetJudgeScoresOfEveryone(int scores)
    {
        HttpContext.Current.Session["judgeScores"] = scores;
    }
    public static int GetJudgeScoresOfEveryone()
    {
        if (HttpContext.Current.Session["judgeScores"] == null)
            return 0;
        return Convert.ToInt32(HttpContext.Current.Session["judgeScores"]);
    }

    public static void SetSingleSelectionScoresOfEveryone(int scores)
    {
        HttpContext.Current.Session["singleSelection"] = scores;
    }
    public static int GetSingleSelectionScoresOfEveryone()
    {
        if (HttpContext.Current.Session["singleSelection"] == null)
            return 0;
        return Convert.ToInt32(HttpContext.Current.Session["singleSelection"]);
    }

    public static void SetMultiSelectionScoresOfEveryone(int scores)
    {
        HttpContext.Current.Session["multiSelection"] = scores;
    }
    public static int GetMultiSelectionScoresOfEveryone()
    {
        if (HttpContext.Current.Session["multiSelection"] == null)
            return 0;
        return Convert.ToInt32(HttpContext.Current.Session["multiSelection"]);
    }

    public static void SetSimpleAnswerScores(List<SubjectOfSimpleAnswer> subjectList)
    {
        if (subjectList == null)
        {
            HttpContext.Current.Session["simpleAnswerScores"] = null;
            return;
        }
        HttpContext.Current.Session["simpleAnswerScores"] = Tool.SerializeHelper.SerializeObject(subjectList);
    }

    public static List<SubjectOfSimpleAnswer> GetSimpleAnswerScores()
    {
        if (null == HttpContext.Current.Session["simpleAnswerScores"])
            return null;
        return (List<SubjectOfSimpleAnswer>)Tool.SerializeHelper.DeserializeObject(HttpContext.Current.Session["simpleAnswerScores"].ToString());
    }

    #endregion
}
