﻿<%@ page title="" language="C#" masterpagefile="~/Main.master" autoeventwireup="true" inherits="Reset, Website_deploy" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<div class="main">
    <div class="title">重置密码</div>
    <div class="ctr">
        <label>注册邮箱</label>
        <asp:TextBox ID="txt_usermail" runat="server" Font-Size="Large" Height="35px" 
            Width="200px"></asp:TextBox>
        <asp:Button ID="btn_verif" runat="server" Text="获取邮箱校验码" Height="30px" 
            onclick="btn_verif_Click" ValidationGroup="verif" Width="140px" />
        <asp:RequiredFieldValidator ID="rfv_usermail" runat="server" ErrorMessage="*" 
            ControlToValidate="txt_usermail" ValidationGroup="Reset"></asp:RequiredFieldValidator>
        <asp:RegularExpressionValidator ID="reg_usermail" runat="server" 
            ErrorMessage="请填写正确的邮箱" 
            ValidationExpression="^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$" 
            ControlToValidate="txt_usermail" ValidationGroup="Reset"></asp:RegularExpressionValidator>
        <div class="clear"></div>
    </div>
    <div class="ctr">
        <label>邮箱校验码</label>
        <asp:TextBox ID="txt_verif" runat="server" Font-Size="Large" Height="35px" 
            Width="200px"></asp:TextBox>
        <asp:RequiredFieldValidator ID="rfv_verif" runat="server" ErrorMessage="*" 
            ControlToValidate="txt_verif" ValidationGroup="Reset"></asp:RequiredFieldValidator>
        <div class="clear"></div>
    </div>
    <div class="ctr">
        <label>新密码</label>
        <asp:TextBox ID="txt_newpass" runat="server" Font-Size="Large" Height="35px" 
            Width="200px" TextMode="Password"></asp:TextBox>
        <asp:RequiredFieldValidator ID="rfv_newpass" runat="server" ErrorMessage="*" 
            ControlToValidate="txt_newpass" ValidationGroup="Reset"></asp:RequiredFieldValidator>
        <asp:RegularExpressionValidator ID="reg_newpass" runat="server" 
            ErrorMessage="允许字母数字，长度5-15个字符" 
            ValidationExpression="^[A-Za-z0-9]{5,15}$" ControlToValidate="txt_newpass" 
            ValidationGroup="Reset"></asp:RegularExpressionValidator>
        <div class="clear"></div>
    </div>
    <div class="ctr">
        <label>重复新密码</label>
        <asp:TextBox ID="txt_newpass2" runat="server" Font-Size="Large" Height="35px" 
            Width="200px" TextMode="Password"></asp:TextBox>
        <asp:RequiredFieldValidator ID="rfv_newpass2" runat="server" ErrorMessage="*" 
            ControlToValidate="txt_newpass2" ValidationGroup="Reset"></asp:RequiredFieldValidator>
        <asp:CompareValidator ID="comp_newpass2" runat="server" 
            ErrorMessage="两次输入的密码不一致" ControlToCompare="txt_newpass" 
            ControlToValidate="txt_newpass2" ValidationGroup="Reset"></asp:CompareValidator>
        <div class="clear"></div>
    </div>
    <div class="ctr">
        <label>验证码</label>
        <asp:TextBox ID="txt_vcode" runat="server" Font-Size="Large" Height="35px" 
            Width="70px"></asp:TextBox>
        <img alt="验证码" onclick="this.src=this.src+'?'" src="Inc/Verification_code.aspx?" />
                <span>看不清，点击图片刷新</span>
        <asp:RequiredFieldValidator ID="rfv_vcode" runat="server" ErrorMessage="*" 
            ControlToValidate="txt_vcode" ValidationGroup="Reset"></asp:RequiredFieldValidator>

        <div class="clear"></div>
    </div>
    <div class="btn">
        <asp:Button ID="btn_reset" runat="server" Text="提交" Height="30px" 
            onclick="btn_reset_Click" ValidationGroup="Reset" Width="60px" />
    </div>
</div>
</asp:Content>

