﻿<%@ page language="C#" autoeventwireup="true" inherits="Wap_Reg, Website_deploy" %>

<!DOCTYPE html>
<html>
<head id="Head1" runat="server">
<meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" name="viewport" /> 
<meta content="yes" name="apple-mobile-web-app-capable" /> 
<meta content="black" name="apple-mobile-web-app-status-bar-style" /> 
<meta content="telephone=no" name="format-detection" />
<link href="wap.css" rel="stylesheet" type="text/css" />    
<title>手机版</title>
</head>
<body>
<form id="form1" runat="server">
<div class="reg_title">注册新帐号</div>
        <div class="reg_ctr">
            <label>邮箱</label>
            <asp:TextBox ID="txt_mail" runat="server" Font-Size="Larger" Height="35px" 
                Width="230px"></asp:TextBox>
            <asp:RegularExpressionValidator ID="rev_mail" runat="server" 
                    ControlToValidate="txt_mail" Display="Dynamic" 
                    ErrorMessage="请填写真实有效的邮箱，用于密码忘记后找回。" 
                    ValidationExpression="^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$" 
                    ValidationGroup="reg" Font-Size="Small"></asp:RegularExpressionValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_ctr">
            <label>昵称</label>
            <asp:TextBox ID="txt_nick" runat="server" Font-Size="Larger" Height="35px" 
                Width="230px"></asp:TextBox>
            <asp:RegularExpressionValidator ID="rev_nick" runat="server" 
                ControlToValidate="txt_nick" Display="Dynamic" 
                    ErrorMessage="允许中文、英文、数字及下划线，长度20个字符以内" 
                    ValidationExpression="^[\u4e00-\u9fa5_a-zA-Z0-9]+$" ValidationGroup="reg" 
                    Font-Size="Small"></asp:RegularExpressionValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_ctr">
            <label>创建密码</label>
            <asp:TextBox ID="txt_pass" runat="server" Font-Size="Larger" Height="35px" 
                TextMode="Password" Width="230px"></asp:TextBox>
            <asp:RegularExpressionValidator ID="rev_pass" runat="server" 
                    ControlToValidate="txt_pass" Display="Dynamic" 
                    ErrorMessage="允许字母数字，长度5-15个字符" 
                    ValidationExpression="^[A-Za-z0-9]{5,15}$" ValidationGroup="reg" 
                    Font-Size="Small"></asp:RegularExpressionValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_ctr">
            <label>确认密码</label>
            <asp:TextBox ID="txt_pass2" runat="server" Font-Size="Larger" Height="35px" 
                TextMode="Password" Width="230px"></asp:TextBox>
            <asp:CompareValidator ID="cv_pass2" runat="server" 
                    ControlToCompare="txt_pass" ControlToValidate="txt_pass2" 
                    Display="Dynamic" ErrorMessage="两次输入的密码不一致" 
                    ValidationGroup="reg" Font-Size="Small"></asp:CompareValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_ctr">
            <label>验证码</label>
            <asp:TextBox ID="txt_vcode" runat="server" Font-Size="Larger" Height="35px" 
                Width="70px"></asp:TextBox>
            <img alt="验证码" onclick="this.src=this.src+'?'" src="../Inc/Verification_code.aspx?" />
                <span>看不清，点击图片刷新</span>
            <asp:RequiredFieldValidator ID="rfv_vcode" runat="server" ErrorMessage="请输入验证码" 
                ControlToValidate="txt_vcode" Display="Dynamic" Font-Size="Small" 
                ValidationGroup="reg"></asp:RequiredFieldValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_btn">
            <asp:Button ID="btn_Reg" runat="server" CssClass="button" Text="注册新帐号" 
                ValidationGroup="reg" onclick="btn_Reg_Click" />
        </div>
        <div class="reg_btn">            
            <span>已有帐号？请<a href="Login.aspx">登录</a></span>
        </div>
</form>
</body>
</html>
