﻿<%@ page language="C#" autoeventwireup="true" inherits="Reg, Website_deploy" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>注册新用户</title>
    <link href="Style/main.css" rel="stylesheet" type="text/css" />
</head>
<body>
<form id="form1" runat="server">
<div class="reg_box">
    <div class="reg_main">
        <div class="reg_title">注册新帐号</div>
        <div class="reg_ctr">
            <label>邮箱</label>
            <asp:TextBox ID="txt_mail" runat="server" Font-Size="Larger" Height="35px" 
                Width="230px"></asp:TextBox>
            <asp:RegularExpressionValidator ID="rev_mail" runat="server" 
                    ControlToValidate="txt_mail" Display="Dynamic" 
                    ErrorMessage="请填写真实有效的邮箱，用于密码忘记后找回。" 
                    ValidationExpression="^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$" 
                    ValidationGroup="reg" Font-Size="Small"></asp:RegularExpressionValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_ctr">
            <label>昵称</label>
            <asp:TextBox ID="txt_nick" runat="server" Font-Size="Larger" Height="35px" 
                Width="230px"></asp:TextBox>
            <asp:RegularExpressionValidator ID="rev_nick" runat="server" 
                ControlToValidate="txt_nick" Display="Dynamic" 
                    ErrorMessage="允许中文、英文、数字及下划线，长度20个字符以内" 
                    ValidationExpression="^[\u4e00-\u9fa5_a-zA-Z0-9]+$" ValidationGroup="reg" 
                    Font-Size="Small"></asp:RegularExpressionValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_ctr">
            <label>创建密码</label>
            <asp:TextBox ID="txt_pass" runat="server" Font-Size="Larger" Height="35px" 
                TextMode="Password" Width="230px"></asp:TextBox>
            <asp:RegularExpressionValidator ID="rev_pass" runat="server" 
                    ControlToValidate="txt_pass" Display="Dynamic" 
                    ErrorMessage="允许字母数字，长度5-15个字符" 
                    ValidationExpression="^[A-Za-z0-9]{5,15}$" ValidationGroup="reg" 
                    Font-Size="Small"></asp:RegularExpressionValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_ctr">
            <label>确认密码</label>
            <asp:TextBox ID="txt_pass2" runat="server" Font-Size="Larger" Height="35px" 
                TextMode="Password" Width="230px"></asp:TextBox>
            <asp:CompareValidator ID="cv_pass2" runat="server" 
                    ControlToCompare="txt_pass" ControlToValidate="txt_pass2" 
                    Display="Dynamic" ErrorMessage="两次输入的密码不一致" 
                    ValidationGroup="reg" Font-Size="Small"></asp:CompareValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_ctr">
            <label>验证码</label>
            <asp:TextBox ID="txt_vcode" runat="server" Font-Size="Larger" Height="35px" 
                Width="70px"></asp:TextBox>
            <img alt="验证码" onclick="this.src=this.src+'?'" src="Inc/Verification_code.aspx?" />
                <span>看不清，点击图片刷新</span>
            <asp:RequiredFieldValidator ID="rfv_vcode" runat="server" ErrorMessage="请输入验证码" 
                ControlToValidate="txt_vcode" Display="Dynamic" Font-Size="Small" 
                ValidationGroup="reg"></asp:RequiredFieldValidator>
            <div class="clear"></div>
        </div>
        <div class="reg_btn">
            <asp:Button ID="btn_Reg" runat="server" CssClass="button" Text="同意以下协议并注册" 
                ValidationGroup="reg" onclick="btn_Reg_Click" />
        </div>
        <div class="reg_btn">
            <span><a href="Agree.aspx" target="_blank">《用户注册协议》</a></span>
            <span>已有帐号？请<a href="Login.aspx">登录</a></span>
        </div>
    </div>
</div>
</form>
</body>
</html>
