﻿<%@ page language="C#" autoeventwireup="true" inherits="User_First, Website_deploy" %>
<%@ Register src="top.ascx" tagname="top" tagprefix="uc1" %>
<%@ Register src="left.ascx" tagname="left" tagprefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>个人中心</title>
    <link href="../Style/ucenter.css" rel="stylesheet" type="text/css" />
</head>
<body>
<form id="form1" runat="server">
<div class="top"> 
    <uc1:top ID="top1" runat="server" />
</div>
<div class="box">
    <div class="left">
        <uc2:left ID="left1" runat="server" />
    </div>
    <div class="right">
        <div class="first">
            <div class="title">QQ登录用户完善资料</div>            
            <div class="btn">
                <span>您可以创建独立的新账户，或者关联已有的账户。</span>
            </div>
            <div class="ctr">
                <label>邮箱</label>
                <asp:TextBox ID="txt_mail" runat="server" Font-Size="Large" Height="35px" 
                    Width="200px"></asp:TextBox>
                <asp:RegularExpressionValidator ID="rev_mail" runat="server" 
                    ControlToValidate="txt_mail" Display="Dynamic" 
                    ErrorMessage="请填写真实有效的邮箱，用于密码忘记后找回。" 
                    ValidationExpression="^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$" 
                    ValidationGroup="reg" Font-Size="Small"></asp:RegularExpressionValidator>
                <div class="clear"></div>
            </div>
            <div class="ctr">
                <label>密码</label>
                <asp:TextBox ID="txt_pass" runat="server" Font-Size="Large" Height="35px" 
                    TextMode="Password" Width="200px"></asp:TextBox>
                <asp:RegularExpressionValidator ID="rev_pass" runat="server" 
                    ControlToValidate="txt_pass" Display="Dynamic" 
                    ErrorMessage="允许字母数字，长度5-15个字符" 
                    ValidationExpression="^[A-Za-z0-9]{5,15}$" ValidationGroup="reg" 
                    Font-Size="Small"></asp:RegularExpressionValidator>
                <div class="clear"></div>
            </div>
            <div class="ctr">
                <label>重复密码</label>
                <asp:TextBox ID="txt_pass2" runat="server" Font-Size="Large" Height="35px" 
                    TextMode="Password" Width="200px"></asp:TextBox>
                <asp:CompareValidator ID="cv_pass2" runat="server" 
                    ControlToCompare="txt_pass" ControlToValidate="txt_pass2" 
                    Display="Dynamic" ErrorMessage="两次输入的密码不一致" 
                    ValidationGroup="reg" Font-Size="Small"></asp:CompareValidator>
                <div class="clear"></div>
            </div>
            <div class="btn">                
                <asp:RadioButtonList ID="Radio_type" runat="server" 
                    RepeatDirection="Horizontal">
                    <asp:ListItem Value="new">创建新账户</asp:ListItem>
                    <asp:ListItem Value="old">关联已有账户</asp:ListItem>
                </asp:RadioButtonList>
            </div>
            <div class="btn">
                <asp:Button ID="btn_first" runat="server" Text="提交" Height="30px" 
                    Width="80px" onclick="btn_first_Click" />
            </div>
        </div>
    </div>
    <div class="clear"></div>
</div>
</form>
</body>
</html>
