﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;

namespace SpaceBuilder.Blog
{
    /// <summary>
    /// 博客中使用Cookie
    /// </summary>
    public static class BlogUserCookie
    {
        private static readonly string BlogThreadsListModeCookieKey = "BlogThreasListMode";
        private static readonly char BlogCookieKeyValueSeparator = ',';
        private static readonly char BlogCookieContentSeparator = '|';

        private static readonly string AuthorizedBlogThreadCookieKey = "AuthorizedBlogThreads";

        /// <summary>
        /// 保存已授权的博客文章ID集合
        /// </summary>
        public static void SaveAuthorizedBlogThreadIDs(this UserCookie userCookieObject, int threadID, string password)
        {
            //检测是否已存在于Cookie中
            if (userCookieObject.AuthorizeBlogThreadID(threadID))
                return;
            if (userCookieObject.Cookie != null)
            {
                string oldthreadIDs = userCookieObject.Cookie[AuthorizedBlogThreadCookieKey];
                userCookieObject.Cookie[AuthorizedBlogThreadCookieKey] = EncryptManager.EncryptTokenForInviteFriend(string.Format("{0}{1}{2},{3}", oldthreadIDs, BlogCookieContentSeparator, threadID.ToString(), password));
                userCookieObject.WriteCookie();
            }
        }

        /// <summary>
        /// 获取已授权的博客文章ID集合
        /// </summary>
        /// <returns>
        /// 例如：1,2,6,
        /// </returns>
        public static bool AuthorizeBlogThreadID(this UserCookie userCookieObject, int threadID)
        {
            if (userCookieObject.Cookie == null)
                return false;

            BlogThread thread = BlogThreads.GetThread(threadID, null, true);
            if (thread == null)
                return false;

            string threadIDs = EncryptManager.DecryptTokenForInviteFriend(userCookieObject.Cookie[AuthorizedBlogThreadCookieKey]);
            if (!string.IsNullOrEmpty(threadIDs))
            {
                string[] blogThreadsArray = threadIDs.Split(new char[] { BlogCookieContentSeparator }, StringSplitOptions.RemoveEmptyEntries);
                if (blogThreadsArray != null && blogThreadsArray.Length > 0)
                {
                    Dictionary<int, string> blogThreads = new Dictionary<int, string>();
                    foreach (string threadStr in blogThreadsArray)
                    {
                        string[] items = threadStr.Split(new char[] { BlogCookieKeyValueSeparator }, StringSplitOptions.RemoveEmptyEntries);
                        if (items != null && items.Length > 1)
                        {
                            int i = 0;
                            int.TryParse(items[0], out i);
                            if (i > 0)
                                blogThreads[i] = items[1];
                        }
                    }
                    return blogThreads.ContainsKey(threadID) && BlogThreads.ValidPrivacyPassword(blogThreads[threadID], thread.Password);
                }
            }
            return false;
        }

        /// <summary>
        /// 保存博客文章列表的显示方式
        /// </summary>
        public static void SaveBlogThreadsListMode(this UserCookie userCookieObject, bool summary)
        {

            if (userCookieObject.Cookie != null)
            {
                userCookieObject.Cookie[BlogThreadsListModeCookieKey] = summary.ToString();
                userCookieObject.WriteCookie();
            }
        }

        /// <summary>
        /// 读取博客文章列表的显示方式（true 为摘要显示(也是默认状态)，false 为列表显示）
        /// </summary>
        public static bool GetBlogThreadListsMode(this UserCookie userCookieObject)
        {
            bool summary = true;

            if (userCookieObject.Cookie != null)
            {
                string summaryString = userCookieObject.Cookie[BlogThreadsListModeCookieKey];
                if (!string.IsNullOrEmpty(summaryString))
                {
                    try
                    {
                        summary = bool.Parse(summaryString);
                    }
                    catch
                    { }
                }
            }

            return summary;
        }
    }
}
