﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Blog;
using SpaceBuilder.Common.Controllers;
using SpaceBuilder.Common;

using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Blog.Controllers
{
    [ManageAuthorize]
    [HttpCompress]
    public class ManageBlogController : ManageControllerBase
    {
        private int BlogApplicationID = ApplicationIDs.Instance().Blog();
        #region 博客文章管理
        /// <summary>
        /// 置顶使用
        /// </summary>
        private int topSpecialOrder = 1;

        /// <summary>
        /// 博客文章列表页
        /// </summary>
        /// <param name="status"></param>
        /// <returns></returns>
        public ActionResult ListBlogArticle(AuditingStatusesForDisplay? status)
        {
            SetPageTitle(GetResourceString("Title_BlogManage", BlogApplicationID));
            ViewData["status"] = AuditingStatusesForDisplay.Pending;
            if (status.HasValue)
                ViewData["status"] = (AuditingStatusesForDisplay)status;

            int intStatus = Request.QueryString.GetInt("status", -1);
            if (intStatus > 0)
                ViewData["status"] = (AuditingStatusesForDisplay)intStatus;

            return View("Pages/Blog/ManageBlogs.aspx", "Masters/Blog.master");
        }

        /// <summary>
        /// 博客文章列表控件
        /// </summary>
        /// <param name="status"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public ActionResult Control_ListBlogArticle(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            int OwnerUserID = Request.QueryString.GetInt("OwnerUserID", -1);
            string SubjectKeywords = Request.QueryString.GetString("KeyWords", string.Empty).Trim();

            PagingDataSet<BlogThread> pds = BlogThreads.GetThreadsForAdmin(17, pageIndex ?? 1, status ?? AuditingStatusesForDisplay.Success, OwnerUserID, SubjectKeywords);
            return PartialView("Controls/Blog/ListBlogArticle.ascx", pds);
        }

        /// <summary>
        /// 批量更新文章状态
        /// </summary>
        /// <param name="returnUrl"></param>
        /// <param name="auditingStatus"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateArticleAuditingStatus(string returnUrl, AuditingStatuses auditingStatus)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }


                    BlogThreads.UpdateAuditingStatus(ListThreadID, auditingStatus);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_BlogArticleBatchWorkSuccess", BlogApplicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectWorkBlogArticle", BlogApplicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 删除单个文章
        /// </summary>
        /// <param name="status"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult DeleteBlogArticle(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            int threadID = Request.QueryString.GetInt("threadID", -1);
            if (threadID < 0)
                throw new ArgumentException(GetResourceString("Exception_ArticleThreadIDError", BlogApplicationID));
            BlogThreads.DeleteThread(threadID);
            //return RedirectToAction("ListBlogArticle", "ManageBlog",new RouteValueDictionary { status = status.HasValue ? (AuditingStatusesForDisplay)status : AuditingStatusesForDisplay.Success, pageIndex = pageIndex ?? 1 });
            return Redirect(Request.UrlReferrer.ToString());
        }

        /// <summary>
        /// 批量删除文章
        /// </summary>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteBlogArticles(string returnUrl)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        if (int.TryParse(Id, out threadID) && threadID > 0)
                            ListThreadID.Add(threadID);
                    }

                    BlogThreads.DeleteThreads(ListThreadID);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_BlogArticleBatchDeleteSuccess", BlogApplicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectWorkBlogArticle", BlogApplicationID);
            }
            return Redirect(returnUrl);
        }



        /// <summary>
        /// 设置为精华
        /// </summary>
        public ActionResult SetEssential(string returnUrl)
        {
            if (!CurrentUser.IsContentAdministrator)
            {
                throw new ArgumentException(GetResourceString("Exception_AdminSetHighLimit"));
            }
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }

                    BlogThreads.SetEssential(ListThreadID, true);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_BlogArticleBatchSetEssentialSuccess", BlogApplicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectWorkBlogArticle", BlogApplicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 取消精华设置
        /// </summary>
        public ActionResult CancelEssential(string returnUrl)
        {

            if (!CurrentUser.IsContentAdministrator)
            {
                throw new ArgumentException(GetResourceString("Exception_OnlyAdministratorCancelEssentialPopedom", BlogApplicationID));
            }
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }

                    BlogThreads.SetEssential(ListThreadID, false);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_BlogArticleBatchCancelEssentialSuccess", BlogApplicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectWorkBlogArticle", BlogApplicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 设为置顶
        /// </summary>
        public ActionResult SetTop(string returnUrl)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }


                    BlogThreads.SetSticky(ListThreadID, topSpecialOrder);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_BlogArticleBatchSetTopSuccess", BlogApplicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectWorkBlogArticle", BlogApplicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 取消置顶
        /// </summary>
        public ActionResult CancelTop(string returnUrl)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }

                    BlogThreads.SetSticky(ListThreadID, 0);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_BlogArticleBatchCancelTopSuccess", BlogApplicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectWorkBlogArticle", BlogApplicationID);
            }
            return Redirect(returnUrl);
        }


        #endregion

        #region 博客评论管理

        /// <summary>
        /// 博客评论显示列表页
        /// </summary>
        /// <param name="status"></param>
        /// <returns></returns>
        public ActionResult ListBlogComments(AuditingStatusesForDisplay? status)
        {
            SetPageTitle(GetResourceString("Title_BlogManage", BlogApplicationID));
            ViewData["status"] = AuditingStatusesForDisplay.Pending;
            if (status.HasValue)
                ViewData["status"] = (AuditingStatusesForDisplay)status;

            int intStatus = Request.QueryString.GetInt("status", -1);
            if (intStatus > 0)
                ViewData["status"] = (AuditingStatusesForDisplay)intStatus;

            return View("Pages/Blog/ManageBlogComments.aspx", "Masters/Blog.master");
        }

        /// <summary>
        /// 博客评论显示列表控件
        /// </summary>
        /// <param name="status"></param>
        /// <returns></returns>
        public ActionResult Control_ListBlogComments(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            int userID = Request.QueryString.GetInt("CommentUserID", -1);
            string bodyKeywords = Request.QueryString.GetString("CommentKeyWords", string.Empty);

            PagingDataSet<BlogComment> pds = BlogComments.GetCommentsForAdmin(17, pageIndex ?? 1, status ?? AuditingStatusesForDisplay.Success, userID, bodyKeywords);
            return PartialView("Controls/Blog/ListBlogComments.ascx", pds);
        }

        /// <summary>
        /// 批量更新文章评论的状态
        /// </summary>
        /// <param name="returnUrl">返回的地址</param>
        /// <param name="auditingStatus">状态 AuditingStatuses 枚举</param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateCommentAuditingStatus(string returnUrl, AuditingStatuses auditingStatus)
        {
            string selectedPostIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedPostIDsString))
            {
                string[] selectedPostIDsStringArray = selectedPostIDsString.Split(',');
                if (selectedPostIDsStringArray != null && selectedPostIDsStringArray.Length > 0)
                {
                    int postID;
                    List<int> ListPostID = new List<int>();
                    foreach (string Id in selectedPostIDsStringArray)
                    {
                        try
                        {
                            postID = int.Parse(Id);
                            ListPostID.Add(postID);
                        }
                        catch { }
                    }


                    BlogComments.UpdateAuditingStatus(ListPostID, auditingStatus);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_CommentBatchWorkSuccess", BlogApplicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectNeedWorkComment", BlogApplicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        ///批量删除文章评论 
        /// </summary>
        /// <param name="returnUrl">返回的url</param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteBlogComments(string returnUrl)
        {
            string selectedPostIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedPostIDsString))
            {
                string[] selectedPostIDsStringArray = selectedPostIDsString.Split(',');
                if (selectedPostIDsStringArray != null && selectedPostIDsStringArray.Length > 0)
                {
                    List<int> IDs = new List<int>();
                    foreach (string id in selectedPostIDsStringArray)
                    {
                        int addId = 0;
                        if (int.TryParse(id, out addId) && addId > 0)
                            IDs.Add(addId);

                    }
                    BlogComments.DeleteComments(IDs);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_ArticleCommentBatchDeleteSuccess", BlogApplicationID);
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectNeedDeleteArticleComment", BlogApplicationID);
            }
            return Redirect(returnUrl);
        }
        #endregion

        #region 博客站点类别管理

        /// <summary>
        /// 站点类别列表
        /// </summary>
        /// <returns></returns>
        public ActionResult BlogCategories()
        {
            SetPageTitle(GetResourceString("Title_BlogManage", BlogApplicationID));
            ViewData["SiteCategoryDepth"] = BlogSectionConfiguration.Instance().SiteCategoryLevel - 1;
            return View("Pages/Blog/ManageBlogCategories.aspx", "Masters/Blog.master");
        }

        /// <summary>
        /// 设置站点类别
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Control_SetSiteCategories()
        {
            string selectedThreadIDsString = Request["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                ViewData["ListThreadID"] = selectedThreadIDsString;
            }
            else
            {
                ViewData["StatusMessageType"] = (int)StatusMessageType.Error;
                ViewData["StatusMessageContent"] = GetResourceString("Message_SelectWorkBlogArticle", BlogApplicationID);
                return PartialView("Controls/Blog/SetSiteCategories.ascx");
            }

            List<SiteCategory> allCategories = SiteCategories.Instance(ApplicationIDs.Instance().Blog()).GetAll(true);
            return PartialView("Controls/Blog/SetSiteCategories.ascx", allCategories);
        }

        /// <summary>
        /// 更新站点类别
        /// </summary>
        /// <param name="selectedThreadIDsString"></param>
        /// <returns></returns>
        public ActionResult Control_UpdateSiteCategories(string selectedThreadIDsString)
        {
            string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
            if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
            {
                int threadID;
                List<int> ListThreadID = new List<int>();
                foreach (string Id in selectedThreadIDsStringArray)
                {
                    try
                    {
                        threadID = int.Parse(Id);
                        ListThreadID.Add(threadID);
                    }
                    catch { }
                }
                int CategoryID = Request.Form.GetInt("toCategoryID", -1);
                if (CategoryID > 0)
                {
                    BlogThreads.UpdateThreadsSiteCategory(ListThreadID, CategoryID);
                    ViewData["StatusMessageType"] = (int)StatusMessageType.Success;
                    ViewData["StatusMessageContent"] = GetResourceString("Message_SetSiteCategoryBatchWorkSuccess", BlogApplicationID);
                }
                else
                {
                    ViewData["StatusMessageType"] = (int)StatusMessageType.Hint;
                    ViewData["StatusMessageContent"] = GetResourceString("Message_SetSiteCategoryWorkFailed", BlogApplicationID);
                }

            }
            ViewData["ListThreadID"] = selectedThreadIDsString;
            List<SiteCategory> allCategories = SiteCategories.Instance(ApplicationIDs.Instance().Blog()).GetAll(true);
            return PartialView("Controls/Blog/SetSiteCategories.ascx", allCategories);
        }
        #endregion

        #region 文章类型管理

        /// <summary>
        /// 管理文章类型
        /// </summary>
        /// <returns>站点中所有的文章类型</returns>
        public ActionResult ManageBlogThreadTypes()
        {
            SetPageTitle(GetResourceString("Title_ArticleTypeManage", BlogApplicationID));
            return View("Pages/Blog/ManageBlogThreadTypes.aspx", "Masters/Blog.master");
        }

        /// <summary>
        /// 管理文章类型-控件
        /// </summary>
        public ActionResult Control_ManageBlogThreadTypes()
        {
            List<BlogThreadType> blogThreadTypes = BlogThreads.GetAllBlogThreadTypes(true);
            return View("Controls/Blog/ManageBlogThreadTypes.ascx", blogThreadTypes);
        }

        /// <summary>
        /// 添加，编辑 文章类型
        /// </summary>
        /// <param name="typeID">需要编辑的文章类型，如果小于等于0 则表示新建文章类型</param>
        public ActionResult Control_EditBlogThreadType(int typeID)
        {
            BlogThreadType blogThreadType = new BlogThreadType();
            if (typeID > 0)
            {
                blogThreadType = BlogThreads.GetBlogThreadType(typeID, true);
                blogThreadType.TypeName = Formatter.FormatSingleLinePlainTextForEdit(blogThreadType.TypeName);
                if (blogThreadType == null)
                {
                    return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ArticleTypeNoFind", BlogApplicationID), typeID)));
                }
            }
            else
            {
                blogThreadType.TypeID = -1;
                blogThreadType.TypeName = string.Empty;
            }

            return PartialView("Controls/Blog/EditBlogThreadType.ascx", blogThreadType);
        }

        /// <summary>
        /// 创建，更新文章类型
        /// </summary>
        /// <param name="typeID">需要编辑的文章类型，如果小于等于0 则表示新建文章类型</param>
        public ActionResult UpdateBlogThreadType(int typeID)
        {
            BlogThreadType blogThreadType = new BlogThreadType();
            if (typeID > 0)
            {
                blogThreadType = BlogThreads.GetBlogThreadType(typeID, true);
                if (blogThreadType == null)
                {
                    return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ArticleTypeNoFind", BlogApplicationID), typeID)));
                }
                blogThreadType.TypeName = Request.Form.GetString("typeName", string.Empty).Trim();
                blogThreadType.TypeName = Formatter.FormatSingleLinePlainTextForStorage(blogThreadType.TypeName);

                if (string.IsNullOrEmpty(blogThreadType.TypeName))
                {
                    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                    TempData["StatusMessageContent"] = GetResourceString("Exception_ArticleTypeNotNull", BlogApplicationID);
                    return RedirectToAction("Control_EditBlogThreadType", "ManageBlog", new RouteValueDictionary { { "typeID", typeID } });
                }
                BlogThreads.UpdateBlogThreadType(blogThreadType);
            }
            else
            {
                blogThreadType.TypeName = Request.Form.Get<string>("typeName", string.Empty);
                if (string.IsNullOrEmpty(blogThreadType.TypeName))
                {
                    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                    TempData["StatusMessageContent"] = GetResourceString("Exception_ArticleTypeNotNull", BlogApplicationID);
                    return RedirectToAction("Control_EditBlogThreadType", "ManageBlog", new RouteValueDictionary { { "typeID", typeID } });
                }
                BlogThreads.CreatBlogThreadType(blogThreadType);
            }
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = GetResourceString("Message_WorkSuccess", BlogApplicationID);

            return RedirectToAction("Control_EditBlogThreadType", "ManageBlog", new RouteValueDictionary { { "typeID", typeID } });
        }

        /// <summary>
        /// 删除文章类型
        /// </summary>
        /// <param name="typeID">要删除的文章类型的TypeID</param>
        public ActionResult DeleteBlogThreadType(int typeID)
        {
            BlogThreadType blogThreadType = BlogThreads.GetBlogThreadType(typeID, true);
            if (blogThreadType == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ArticleTypeNoFind", BlogApplicationID), typeID)));
            }
            BlogThreads.DeleteBlogThreadType(typeID);

            return Control_ManageBlogThreadTypes();
        }

        #endregion

        #region 标签管理
        /// <summary>
        /// 标签管理
        /// </summary>
        /// <returns></returns>
        public ActionResult ManageSiteTags()
        {
            return View("Pages/Blog/ManageSiteTags.aspx", "Masters/Blog.master");
        }
        #endregion

        /// <summary>
        /// 获取博客统计数据
        /// </summary>
        public JsonResult GetManageableCounts()
        {

            Dictionary<BlogManageableCounts, int> dictionary = BlogThreads.GetManageableCounts();
            Application blogApplication = Applications.GetApplication(ApplicationIDs.Instance().Blog());
            List<ManageableCount> list = new List<ManageableCount>();
            list.Add(new ManageableCount { Name = "新增文章数", Value = blogApplication.CountInPast24Hours });
            if (dictionary.ContainsKey(BlogManageableCounts.PendingThreadCount))
                list.Add(new ManageableCount { Name = "待审核文章", Value = dictionary[BlogManageableCounts.PendingThreadCount], Url = SPBUrlHelper.Action("ListBlogArticle", "ManageBlog", new RouteValueDictionary { { "status", AuditingStatusesForDisplay.Pending } }) });
            if (dictionary.ContainsKey(BlogManageableCounts.PendingThreadCount))
                list.Add(new ManageableCount { Name = "需再审核文章", Value = dictionary[BlogManageableCounts.AgainThreadCount], Url = SPBUrlHelper.Action("ListBlogArticle", "ManageBlog", new RouteValueDictionary { { "status", AuditingStatusesForDisplay.Again } }) });
            if (dictionary.ContainsKey(BlogManageableCounts.PendingThreadCount))
                list.Add(new ManageableCount { Name = "待审核评论", Value = dictionary[BlogManageableCounts.PendingThreadCount], Url = SPBUrlHelper.Action("ListBlogComments", "ManageBlog", new RouteValueDictionary { { "status", AuditingStatusesForDisplay.Pending } }) });
            list.Add(new ManageableCount { Name = "总文章数", Value = blogApplication.TotalCount });
            return Json(list,JsonRequestBehavior.AllowGet);
        }
    }



    #region BlogSubMenu
    /// <summary>
    /// BlogSubMenu
    /// </summary>
    public enum BlogSubMenu
    {
        /// <summary>
        /// 博客文章管理
        /// </summary>
        ManageBlogThreads = 2401,

        /// <summary>
        /// 博客评论管理
        /// </summary>
        ManageBlogComments = 2406,

        /// <summary>
        /// 博客站点类别
        /// </summary>
        ManageBlogSiteCategories = 2409,

        /// <summary>
        /// 博客文章类型（原创，转帖）
        /// </summary>
        ManageBlogThreadTypes = 2411,
        /// <summary>
        /// 标签管理
        /// </summary>
        ManageSiteTags = 2412,
    }
    #endregion
}
