﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using SpaceBuilder.Blog;
using SpaceBuilder.Utils;
using System.IO;

using SpaceBuilder.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Common.Handlers;

namespace SpaceBuilder.Blog.Handlers
{
    /// <summary>
    /// 博客附件处理程序，用于显示或下载附件
    /// </summary>
    /// <remarks>
    /// 对于图片等附件直接在浏览器中进行显示，对于不能在浏览器中显示的附件弹出下载对话框
    /// </remarks>
    public class AttachmentHandler : DownloadFileHandlerBase
    {
        /// <summary>
        /// 向客户端输出附件
        /// </summary>        
        public override void ProcessRequest(HttpContext context)
        {
            //防盗链检测
            if (SPBConfig.Instance().EnableAntiLeech && !Globals.IsAllowableReferrer(context.Request))
            {
                context.Response.Redirect(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/anti-Leech.gif"), true);
                return;
            }

            int attachmentID = context.Request.QueryString.GetInt("AttachmentID", -1);
            if (attachmentID <= 0)
            {
                WebUtils.Return404(context);
                return;
            }

            Attachment attachment = BlogAttachmentManager.Instance().GetAttachment(attachmentID, true);
            if (attachment == null)
            {
                WebUtils.Return404(context);
                return;
            }

            IFile file = attachment.File;
            if (file == null)
            {
                WebUtils.Return404(context);
                return;
            }

            DateTime lastModified = attachment.DateCreated.ToUniversalTime();
            if (IsCacheOK(context, lastModified))
            {
                WebUtils.Return304(context);
                return;
            }
            else
            {
                SetResponsesDetails(context, attachment.ContentType, attachment.FriendlyFileName, lastModified);

                FileSystemFile fileSystemFile = file as FileSystemFile;
                if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                {
                    // Send files stored on UNC paths explicitly to avoid a bug with TransmitFile.
                    context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                }
                else
                {
                    context.Response.AddHeader("Content-Length", file.ContentLength.ToString("0"));
                    context.Response.Buffer = false;
                    context.Response.BufferOutput = false;

                    Stream stream = null;
                    try
                    {
                        stream = attachment.OpenReadStream();
                        if (stream == null)
                        {
                            WebUtils.Return404(context);
                            return;
                        }

                        int bufferLength = fileSystemFile.ContentLength <= DownloadFileHandlerBase.BufferLength ? file.ContentLength : DownloadFileHandlerBase.BufferLength;
                        byte[] buffer = new byte[bufferLength];
                        int readedSize;
                        while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                        {
                            if (!context.Response.IsClientConnected)
                                break;

                            context.Response.OutputStream.Write(buffer, 0, readedSize);
                            context.Response.OutputStream.Flush();
                        }
                        context.Response.OutputStream.Flush();
                        context.Response.Flush();

                    }
                    catch (Exception ex)
                    {
                        context.Response.Redirect(SiteUrls.Instance().Error(ex.ToString()), true);
                        return;
                    }
                    finally
                    {
                        if (stream != null)
                            stream.Close();
                    }
                }

                context.Response.Cache.VaryByParams["AttachmentID"] = true;
                context.Response.End();
            }
        }

    }
}

