﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;
using System.Web;

using SpaceBuilder.Utils;
using SpaceBuilder.Web;

using System.Web.Mvc;
using SpaceBuilder.Blog.Controllers;
using SpaceBuilder.Common;
using SpaceBuilder.Blog;

namespace SpaceBuilder.Blog.Handlers
{
    /// <summary>
    /// 处理特殊的ForumUrl
    /// </summary>
    public class BlogCommentUrlHandler : IHttpHandler
    {
        public bool IsReusable
        {
            get { return true; }
        }

        public void ProcessRequest(HttpContext context)
        {

            string url = string.Empty;
            int anchorPostID = 0;
            if (!string.IsNullOrEmpty(context.Request.QueryString["anchorPostID"]))
            {
                int.TryParse(context.Request.QueryString["anchorPostID"], out anchorPostID);
            }

            int threadID = 0;
            if (!string.IsNullOrEmpty(context.Request.QueryString["ThreadID"]))
            {
                int.TryParse(context.Request.QueryString["ThreadID"], out threadID);
            }

            int pageIndex = 1;
            BlogThread thread = BlogThreads.GetThread(threadID, null, true);
            if (thread != null)
            {

                if (thread.CommentCount++ > BlogSectionConfiguration.Instance().CommentsPerPage)
                {
                    pageIndex = thread.CommentCount / BlogSectionConfiguration.Instance().CommentsPerPage;
                    if ((thread.CommentCount % BlogSectionConfiguration.Instance().CommentsPerPage) > 0)
                    {
                        pageIndex++;
                    }
                }
            }

            if (anchorPostID > 0)
                url = SiteUrls.Instance().ShowBlogCommentsPaged(thread, pageIndex, anchorPostID);
            else
                url = SiteUrls.Instance().ShowBlogCommentsPaged(thread, pageIndex);

            WebUtils.Redirect301(context, url);
        }
    }
}
