﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;
using System.Web;

using SpaceBuilder.Blog;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

using System.Web.Mvc;
using SpaceBuilder.Blog.Controllers;
using SpaceBuilder.Common;

namespace SpaceBuilder.Blog.Handlers
{
    /// <summary>
    /// 处理特殊的ForumUrl
    /// </summary>
    public class BlogUrlHandler : IHttpHandler
    {
        public bool IsReusable
        {
            get { return true; }
        }

        public void ProcessRequest(HttpContext context)
        {
            string url = string.Empty;
            int anchorPostID = 0;
            if (string.IsNullOrEmpty(context.Request.QueryString["anchorPostID"]) == false)
                int.TryParse(context.Request.QueryString["anchorPostID"], out anchorPostID);

            int threadID = 0;
            if (string.IsNullOrEmpty(context.Request.QueryString["ThreadID"]) == false)
                int.TryParse(context.Request.QueryString["ThreadID"], out threadID);

            int parentID = 0;
            if (string.IsNullOrEmpty(context.Request.QueryString["ParentID"]) == false)
                int.TryParse(context.Request.QueryString["parentID"], out parentID);

            string userDomainName = string.Empty;
            if (!string.IsNullOrEmpty(context.Request.QueryString["userDomainName"]))
                userDomainName = WebUtils.UrlDecode(context.Request.QueryString["UserDomainName"]);

            BlogThread thread = BlogThreads.GetThread(threadID, null, false);
            if (thread != null)
            {
                int pageIndex = 1;
                int commentCount = BlogComments.GetCommentcount(thread.ThreadID, parentID, false);
                if (commentCount > BlogSectionConfiguration.Instance().CommentsPerPage)
                {
                    pageIndex = commentCount / BlogSectionConfiguration.Instance().CommentsPerPage;
                    if ((commentCount % BlogSectionConfiguration.Instance().CommentsPerPage) > 0)
                        pageIndex++;
                }

                if (anchorPostID > 0)
                    url = SiteUrls.Instance().ShowBlogThread(userDomainName, thread, pageIndex, anchorPostID);
                else
                    url = SiteUrls.Instance().ShowBlogThread(userDomainName, thread);
            }

            WebUtils.Redirect301(context, url);
        }
    }
}
