﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Xml;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;

using SpaceBuilder.Web;

namespace SpaceBuilder.Blog.Handlers
{
    /// <summary>
    /// LiveWrite发现机制
    /// </summary>
    public class RSDHandler : IHttpHandler
    {
        public void ProcessRequest(HttpContext context)
        {
            int ownerUserID = context.Request.QueryString.GetInt("OwnerUserID", 0);
            if (ownerUserID == 0)
                return;

            User blogOwner = Users.GetUser(ownerUserID, false);
            if (blogOwner == null )
                return;

            context.Response.ContentType = "text/xml";
            XmlTextWriter xml = new XmlTextWriter(context.Response.OutputStream, Encoding.UTF8);

            xml.WriteStartElement("rsd");
            xml.WriteAttributeString("version", "1.0");

            //service
            xml.WriteStartElement("service");
            xml.WriteElementString("engineName", "Metaweblog API");
            xml.WriteElementString("engineLink", "http://spacebuilder.cn");
            xml.WriteElementString("homePageLink", WebUtils.FullPath(SiteUrls.Instance().UserChannelHome(blogOwner, ApplicationIDs.Instance().Blog())));

            xml.WriteStartElement("apis");
            xml.WriteStartElement("api");
            xml.WriteAttributeString("name", "MetaWeblog");
            xml.WriteAttributeString("blogID", blogOwner.UserID.ToString());
            xml.WriteAttributeString("preferred", "true");
            xml.WriteAttributeString("apiLink", WebUtils.FullPath(SiteUrls.Instance().MetaBlog()));
            xml.WriteEndElement();

            xml.WriteEndElement();

            //End service
            xml.WriteEndElement();

            xml.Close();
        }


        /// <summary>
        /// 是否可重用
        /// </summary>
        public bool IsReusable
        {
            get { return true; }
        }

    }
}
