﻿////------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.Web;
//using TunyNet.Utils;
//using System.Xml;
//using System.Text.RegularExpressions;
//using TunyNet.Data.Utils;
//
//using SpaceBuilder.Blog;
//using SpaceBuilder.Common;

//namespace SpaceBuilder.Blogs.Handlers
//{
//    /// <summary>
//    /// Summary description for TrackBackHandler.
//    /// </summary>
//    public class TrackBackHandler : IHttpHandler
//    {

//        public void ProcessRequest(HttpContext context)
//        {
//            context.Response.ContentType = "text/xml";
//            User currentUser = Globals.GetCurrentUser();
//            int postID = 0;
//            try
//            {
//                postID = int.Parse(context.Request.QueryString["postID"]);
//            }
//            catch
//            {
//                trackbackResponse(context, 1, "EntryID is invalid or missing");
//            }


//            if (context.Request.HttpMethod == "POST")
//            {
//                string title = safeParam(context, "title");
//                string excerpt = safeParam(context, "excerpt");
//                string url = safeParam(context, "url");
//                string blog_name = safeParam(context, "blog_name");

//                if (!ValueHelper.IsNullOrEmpty(excerpt))
//                    excerpt = HtmlUtils.TrimHtml(excerpt, 250);
//                try
//                {
//                    // is the url valid ?
//                    if (url == "")
//                        trackbackResponse(context, 1, "no url parameter found, please try harder!");

//                    string pageTitle = null;

//                    BlogThread trackedEntry = BlogPosts.GetThread(postID, true);

//                    if (trackedEntry == null)
//                        trackbackResponse(context, 2, "The link does not exist");


//                    Weblog wl = trackedEntry.Section as Weblog;

//                    Permissions.AccessCheck(wl, Permission.View, currentUser);

//                    if (!wl.EnableTrackbacks)
//                    {
//                        trackbackResponse(context, 2, "Trackbacks are not enabled");
//                        return;
//                    }

//                    if (!IsNewTrackBack(trackedEntry, url))
//                    {
//                        trackbackResponse(context, 2, "Trackbacks already exists");
//                        return;

//                    }

//                    if (trackedEntry != null && !SourceContainsTarget(url, WebUtils.FullPath(SiteUrls.ShowBlogThread(wl.ApplicationKey, trackedEntry)), out pageTitle))
//                    {
//                        trackbackResponse(context, 2, "Sorry couldn't find a relevant link in " + url);
//                    }

//                    BlogPost entry = new BlogPost();
//                    entry.BlogPostType = BlogPostType.Trackback;
//                    entry.SectionID = wl.SectionID;
//                    entry.ParentID = postID;
//                    entry.Subject = title;
//                    entry.TitleUrl = url;
//                    entry.TrackBackName = blog_name;
//                    entry.Body = excerpt;
//                    entry.IsApproved = true;
//                    entry.PostDate = DateTime.Now;
//                    //entry.BloggerTime = DateTime.Now;
//                    BlogPosts.CreatePost(entry);
//                }
//                catch (System.Threading.ThreadAbortException) { }
//                catch (System.Exception ex)
//                {
//                    if (ex.Message != null)
//                        trackbackResponse(context, 0, string.Format("Error occurred while processing Trackback: {0}", ex.Message));
//                    else
//                        trackbackResponse(context, 0, "Unknown error occurred while processing Trackback.");
//                }
//            }
//            else
//            {
//                BlogThread entry = BlogPosts.GetThread(postID, true);

//                Weblog wl = entry.Section as Weblog;
//                Permissions.AccessCheck(wl, Permission.View, currentUser);

//                XmlTextWriter w = new XmlTextWriter(context.Response.Output);
//                w.Formatting = Formatting.Indented;

//                w.WriteStartDocument();
//                w.WriteStartElement("response");
//                w.WriteElementString("error", "0");
//                w.WriteStartElement("rss");
//                w.WriteAttributeString("version", "0.91");
//                w.WriteStartElement("channel");
//                w.WriteElementString("title", entry.Subject);
//                w.WriteElementString("link", SiteUrls.BlogTrackbackPingUrl(postID));
//                w.WriteElementString("description", "");
//                w.WriteElementString("language", "en-us");

//                w.WriteEndElement(); // channel
//                w.WriteEndElement(); // rss 
//                w.WriteEndElement(); // response
//                w.WriteEndDocument();
//            }

//        }

//        public bool IsReusable
//        {
//            get { return true; }
//        }

//        private void trackbackResponse(HttpContext context, int errNum, string errText)
//        {
//            // Log trackback failure messae to the EventLog
//            string message = String.Format("Trackback request received by SpaceBuilder but failed due to one or more reasons. The request URL was [{0}]. Error message returned was: {1}.", context.Request.RawUrl, errText);

//            XmlDocument d = new XmlDocument();
//            XmlElement root = d.CreateElement("response");
//            d.AppendChild(root);
//            XmlElement er = d.CreateElement("error");
//            root.AppendChild(er);
//            er.AppendChild(d.CreateTextNode(errNum.ToString()));
//            if (errText != "")
//            {
//                XmlElement msg = d.CreateElement("message");
//                root.AppendChild(msg);
//                msg.AppendChild(d.CreateTextNode(errText));
//            }
//            d.Save(context.Response.Output);
//            context.Response.End();
//        }

//        private string safeParam(HttpContext context, string pName)
//        {
//            if (context.Request.Form[pName] != null)
//                return WebUtils.HtmlEncode(context.Request.Form[pName]);
//            return string.Empty;
//        }

//        public static bool SourceContainsTarget(string sURI, string tURI, out string pageTitle)
//        {
//            pageTitle = string.Empty;
//            string page = SBRequest.GetPageText(sURI, tURI);
//            if (page == null || page.IndexOf(tURI) < 0)
//                return false;

//            string pat = @"<head.*?>.*<title.*?>(.*)</title.*?>.*</head.*?>";
//            Regex reg = new Regex(pat, RegexOptions.IgnoreCase | RegexOptions.Singleline);
//            Match m = reg.Match(page);
//            if (m.Success)
//            {
//                pageTitle = HtmlUtils.StripAllTags(m.Result("$1"), false);
//                return true;
//            }

//            return false;
//        }

//        protected static bool IsNewTrackBack(BlogThread post, string trackbackUrl)
//        {
//            BlogCommentQuery query = new BlogCommentQuery();
//            query.ThreadID = post.ThreadID;
//            query.PageSize = ValueHelper.GetSafeSqlInt(int.MaxValue);
//            query.IgnorePaging = true;

//            PagingDataSet<BlogPost> blogPosts = BlogPosts.GetComments(query);
//            foreach (BlogPost p in blogPosts.Records)
//            {
//                if ((string.Compare(trackbackUrl, p.TitleUrl, true) == 0) && (p.BlogPostType == BlogPostType.Trackback))
//                    return false;
//            }

//            return true;
//        }



//    }
//}

