﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web.Mvc;


namespace SpaceBuilder.Blog.Handlers
{
    class BlogAttachmentsUploadHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            int currentThreadID = Convert.ToInt32(context.Request["associateID"]);

            // 判断用户是否有上传图片的权限
            if (currentUserID < 1)
            {
                WebUtils.Return404(context);
                return;
            }

            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                WebUtils.Return404(context);
                return;
            }

            BlogThread currentThread = null;
            if (currentThreadID > 0)
            {
                currentThread = BlogThreads.GetThread(currentThreadID, null, false);
                if (currentThread == null)
                {
                    WebUtils.Return404(context);
                    return;
                }
            }

            bool isPermitted = true;
            System.Web.HttpPostedFile postedFile = context.Request.Files["Filedata"];

            if (postedFile.ContentLength > BlogSectionConfiguration.Instance().AttachmentSettings.MaxAttachmentSize * 1024)
            {
                WebUtils.Return404(context);
                return;
            }

            if (!currentUser.IsContentAdministrator && postedFile.ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            {
                context.Response.StatusCode = 200;
                context.Response.Write("{message:'空间容量不足'}");
                context.Response.End();
            }

            if (!string.IsNullOrEmpty(postedFile.FileName))
            {
                string fileTypeString = postedFile.FileName.Substring(postedFile.FileName.LastIndexOf(".") + 1);
                string uploadPhotoTypes = BlogSectionConfiguration.Instance().AttachmentSettings.Extensions;
                string[] types = uploadPhotoTypes.ToLower().Split(new char[] { ',', '，' }, StringSplitOptions.RemoveEmptyEntries);
                isPermitted = types.Contains(fileTypeString.ToLower());
            }

            if (isPermitted)
            {
                BlogAttachment blogAttachment = new BlogAttachment(BlogAttachmentManager.Instance().StorageProviderName, null);
                blogAttachment.OwnerID = currentUser.UserID;
                blogAttachment.UserID = currentUser.UserID;
                blogAttachment.ContentSize = postedFile.ContentLength;
                blogAttachment.ContentType = MimeTypeConfiguration.GetMimeType(postedFile.FileName);
                blogAttachment.DateCreated = DateTime.Now;
                //blogAttachment.FileName = postedFile.FileName;
                blogAttachment.FriendlyFileName = postedFile.FileName;


                if (currentThreadID > 0)
                {
                    blogAttachment.AssociateID = currentThreadID;
                    BlogAttachmentManager.Instance().CreateAttachment(blogAttachment, postedFile.InputStream);
                }
                else
                {
                    BlogAttachmentManager.Instance().CreateTemporaryAttachment(blogAttachment, postedFile.InputStream);
                }

            }
            context.Response.StatusCode = 200;
            context.Response.Write("{ok:true}");
            context.Response.End();
        }

        #endregion
    }
}
