﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Xml;
using SpaceBuilder.Utils;

using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.Blog.Handlers
{
    /// <summary>
    /// 客户端博客编辑器处理
    /// </summary>
    public class WLWManifestHandler : IHttpHandler
    {
        /// <summary>
        /// 进程请求
        /// </summary>
        /// <param name="context">请求上下文</param>
        public void ProcessRequest(HttpContext context)
        {
            int ownerUserID = context.Request.QueryString.GetInt("OwnerUserID", 0);
            if (ownerUserID == 0)
                return;

            User blogOwner = Users.GetUser(ownerUserID, false);
            if (blogOwner == null )
                return;

            context.Response.ContentType = "text/xml";
            XmlTextWriter xml = new XmlTextWriter(context.Response.OutputStream, Encoding.UTF8);

            xml.WriteStartElement("manifest");
            xml.WriteAttributeString("xmlns", "http://schemas.microsoft.com/wlw/manifest/weblog");

            //service
            xml.WriteStartElement("weblog");

            xml.WriteElementString("imageUrl", WebUtils.FullPath(WebUtils.ResolveUrl("~/favicon.ico")));
            xml.WriteElementString("homepageLinkText", "查看我的博客");
            xml.WriteElementString("adminLinkText", "编辑我的博客");
            xml.WriteElementString("adminUrl", WebUtils.FullPath(SiteUrls.Instance().ManageBlogThreads(blogOwner.UserName)));
            xml.WriteElementString("postEditingUrl", WebUtils.FullPath(SiteUrls.Instance().NewBlogThread(blogOwner.UserName)));

            xml.WriteEndElement();

            xml.WriteStartElement("options");

            xml.WriteElementString("supportsPostAsDraft", "Yes");
            xml.WriteElementString("supportsFileUpload", "No");
            xml.WriteElementString("supportsCustomDate", "Yes");
            xml.WriteElementString("supportsCategories", "Yes");
            xml.WriteElementString("supportsCategoriesInline", "Yes");
            xml.WriteElementString("supportsNewCategoriesInline", "Yes");

            xml.WriteElementString("supportsMultipleCategories", "Yes");
            xml.WriteElementString("supportsNewCategories", "Yes");
            xml.WriteElementString("supportsEmbeds", "Yes");
            xml.WriteElementString("supportsAutoUpdate", "Yes");
            //xml.WriteElementString("supportsSlug", "Yes");
            xml.WriteElementString("supportsExcerpt", "Yes");
            //xml.WriteElementString("supportsKeywords", "Yes");
            xml.WriteElementString("supportsKeywords", "No");

            //xml.WriteElementString("supportsExtendedEntries", "Yes");
            xml.WriteElementString("supportsEmptyTitles", "No");

            //End options
            xml.WriteEndElement();

            xml.Close();
        }

        /// <summary>
        /// 是否可再度使用
        /// </summary>
        public bool IsReusable
        {
            get { return true; }
        }
    }
}