﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.Blog.Modules
{
    /// <summary>
    /// 文章评论内容处理包括（标签，js，还有敏感词过滤）
    /// </summary>
   public  class BlogCommentFormatting : IBlogModule
    {

        #region IBlogModule 成员

       public void Init(BlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeBlogCommentChange += new BlogPostEventHandler(em_BeforeBlogCommentChange);
        }

        void em_BeforeBlogCommentChange(BlogComment blogPost, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                if (e.State == ObjectState.Create && SiteSettingsManager.GetSiteSettings().EnableTrackPostsByIP)
                    blogPost.UserHostAddress = WebUtils.IPAddress;

                //处理标签
                blogPost.Body = Formatter.FormatPlainTextComment(blogPost.Body);
                blogPost.Author = WebUtils.HtmlEncode(blogPost.Author);

                //敏感词过滤
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    blogPost.Body = Censors.CensorPost(blogPost.Body);
                    blogPost.Author = Censors.CensorPost(blogPost.Author);
                }

                //表情处理
                if (SPBConfig.Instance().EnableEmoticon)
                    blogPost.Body = EmotionManager.Instance().EmoticonTransforms(blogPost.Body);                    
            }
        }

        #endregion
    }
}
