﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;

using SpaceBuilder.Common;

namespace SpaceBuilder.Blog.Modules
{
    public class BlogSectionFormatting : IBlogModule
    {
        #region IBlogModule 成员

        public void Init(BlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeBlogSectionChange += new BlogSectionEventHandler(em_BeforeBlogSectionChange);
        }

        void em_BeforeBlogSectionChange(BlogSection blogSection, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                //处理标签
                blogSection.SectionName = WebUtils.HtmlDecode(blogSection.SectionName);
                blogSection.Description = WebUtils.HtmlDecode(blogSection.Description);

                //敏感词过滤
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    blogSection.SectionName = Censors.CensorPost(blogSection.SectionName);
                    blogSection.Description = Censors.CensorPost(blogSection.Description);
                }

            }
        }

        #endregion
    }
}
