﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.Blog.Modules
{
    /// <summary>
    /// 文章标题，内容处理包括（标签，js，还有敏感词过滤）
    /// </summary>
    public class BlogThreadFormatting : IBlogModule
    {

        #region IBlogModule 成员

        public void Init(BlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeBlogThreadChange += new BlogThreadEventHandler(em_BeforeBlogThreadChange);
        }

        void em_BeforeBlogThreadChange(BlogThread blogThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                #region 检查发帖时间间隔,防灌水
                if (e.State == ObjectState.Create)
                    Globals.CheckPostDate();
                #endregion

                if (e.State == ObjectState.Create && SiteSettingsManager.GetSiteSettings().EnableTrackPostsByIP)
                    blogThread.UserHostAddress = WebUtils.IPAddress;

                //标签和脚本处理
                blogThread.Subject = Formatter.FormatSingleLinePlainTextForStorage(blogThread.Subject);
                blogThread.BodyForDataTransmission = HtmlScrubber.Clean(blogThread.BodyForDataTransmission, false, true);
                blogThread.Excerpt = Formatter.FormatMultiLinePlainTextForStorage(blogThread.Excerpt, true);

                //敏感词处理
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    blogThread.BodyForDataTransmission = Censors.CensorPost(blogThread.BodyForDataTransmission);
                    //blogThread.Author = Censors.CensorPost(blogThread.Author);
                }
            }
        }

        #endregion
    }
}
