//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Blog;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.Blog.Modules
{
    /// <summary>
    /// BlogصĶ̬
    /// </summary>
    public class DisposeActivityForBlog : IBlogModule
    {
        #region IPostModule Ա
        /// <summary>
        /// ע¼
        /// </summary>
        public void Init(BlogEventManager bem, System.Xml.Linq.XElement node)
        {
            bem.AfterBlogThreadChange += new BlogThreadEventHandler(bem_AfterBlogThreadChange);
            bem.AfterBlogCommentChange += new BlogPostEventHandler(bem_AfterBlogCommentChange);
        }

        void bem_AfterBlogCommentChange(BlogComment blogComment, GlobalEventArgs e)
        {
            if ((e.State == ObjectState.Create))
            {
                User user = Users.GetUser(blogComment.UserID, false);
                if (user == null )
                    return;

                bool activityIsPublic = false;
                string itemKey = ActivityItemKeys.Instance().NewBlogComment();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);

                if (activityItem == null)
                    return;

                BlogThread blogThread = BlogThreads.GetThread(blogComment.ThreadID, null, false);


                if ((blogThread.PrivacyStatus == PrivacyStatuses.Public || blogThread.PrivacyStatus == PrivacyStatuses.OnlyFriend) && blogComment.IsApproved)
                    activityIsPublic = true;

                #region ˶̬

                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewBlogComment", user.Language, activityItem.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), blogThread.Author, GetBlogCommentSubjectWithHyperlink(blogThread, blogComment));
                userActivity.Body = HtmlUtils.TrimHtml(blogComment.Body, 250);
                userActivity.RelativeItemID = blogComment.PostID;
                userActivity.IsPublic = activityIsPublic;

                Activities.CreateUserActivity(userActivity);

                #endregion

                #region Ѷ̬
                if (activityIsPublic)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //жûǷ͸ Ѷ̬Ŀ
                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;
                        friendActivity.Body = HtmlUtils.TrimHtml(blogComment.Body, 250);

                        friendActivity.RelativeItemID = blogComment.PostID;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);

                    }
                }
                #endregion
            }
        }

        void bem_AfterBlogThreadChange(BlogThread blogThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((e.State == ObjectState.Create))
            {
                User user = Users.GetUser(blogThread.OwnerUserID, false);
                if (user == null )
                    return;

                bool activityIsPublic = false;

                string itemKey = ActivityItemKeys.Instance().NewBlogThread();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);

                if (activityItem == null)
                    return;

                if (blogThread.PrivacyStatus == PrivacyStatuses.Public || blogThread.PrivacyStatus == PrivacyStatuses.OnlyFriend)
                    activityIsPublic = true;

                #region ˶̬

                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewBlogThread", user.Language, activityItem.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetBlogCommentSubjectWithHyperlink(blogThread, null));
                userActivity.Body = HtmlUtils.TrimHtml(blogThread.BodyForDataTransmission, 250);
                userActivity.RelativeItemID = blogThread.ThreadID;
                userActivity.RelativeItemName = blogThread.Subject;
                userActivity.IsPublic = activityIsPublic;
                Activities.CreateUserActivity(userActivity);
                #endregion

                #region Ѷ̬
                if (activityIsPublic)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //жûǷ͸ Ѷ̬Ŀ
                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;

                        friendActivity.Body = HtmlUtils.TrimHtml(blogThread.BodyForDataTransmission, 250);

                        friendActivity.RelativeItemID = blogThread.ThreadID;
                        friendActivity.RelativeItemName = blogThread.Subject;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }
        #endregion

        /// <summary>
        /// ȡӵĲ»۵html
        /// </summary>
        private static string GetBlogCommentSubjectWithHyperlink(BlogThread blogThread, BlogComment child)
        {
            if (child != null)
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowBlogThreadGotoPageIndex(blogThread.Owner.UserName, blogThread.ThreadID, child.ParentID > 0 ? child.ParentID : child.PostID, child.PostID), blogThread.Subject);
            else
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowBlogThread(blogThread.Owner.UserName, blogThread), blogThread.Subject);
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;

    }
}
