﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Blog.Modules
{
    /// <summary>
    /// 删除用户时处理博客
    /// </summary>
    public class DisposeBlogForDeleteUser : IGlobalModule
    {

        #region IGlobalModule 成员

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.UserDelete += new UserDeleteEventHandler(gem_UserDelete);

            gem.UserDeleteAndReassignContent += new UserDeleteEventHandler(gem_UserDeleteAndReassignContent);
        }

        void gem_UserDeleteAndReassignContent(User user, string reassignUserName)
        {
            try
            {
                BlogThreads.DeleteUserAndReassignContent(user.UserID, reassignUserName);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("删除用户并转移其博客内容时出现错误", e);
            }
        }

        void gem_UserDelete(User user, string reassignUserName)
        {
            try
            {
                BlogThreads.DeleteUser(user.UserID);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("删除用户博客内容时出现错误", e);
            }
        }

        #endregion
    }
}
