﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Blog;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.Blog.Modules
{
    /// <summary>
    /// 处理与Blog相关的动态、通知
    /// </summary>
    public class DisposeNoticeForBlog : IBlogModule
    {
        #region IPostModule 成员
        /// <summary>
        /// 注册相关事件处理程序
        /// </summary>
        public void Init(BlogEventManager bem, System.Xml.Linq.XElement node)
        {
            bem.AfterBlogCommentChange += new BlogPostEventHandler(bem_AfterBlogCommentChange);
        }

        void bem_AfterBlogCommentChange(BlogComment blogComment, GlobalEventArgs e)
        {
            if ((e.State == ObjectState.Create))
            {
                BlogThread blogThread = BlogThreads.GetThread(blogComment.ThreadID, null, false);
                //通知接收人
                User toUser = null;
                if (blogComment.ParentID > 0)
                {
                    BlogComment parentComment = BlogComments.GetComment(blogComment.ParentID, true, true);
                    if (parentComment != null)
                        toUser = Users.GetUser(parentComment.UserID, false);
                }
                else
                    toUser = Users.GetUser(blogThread.OwnerUserID, false);

                if (blogComment.UserID == blogThread.OwnerUserID)
                    return;
                string itemKey = NoticeItemKeys.Instance().NewBlogComment();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;

                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().Blog();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = blogComment.UserID;
                record.LeadingActor = blogComment.Author;

                if (!string.IsNullOrEmpty(blogComment.TitleUrl) || blogComment.Owner == null)
                    record.LeadingActorUrl = blogComment.TitleUrl;
                else
                    record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Blog());
                if (toUser != null)
                    record.UserID = toUser.UserID;
                record.Receiver = SPBHtmlHelper.Instance().UserDisplayName(toUser);
                record.RelativeItemID = blogThread.ThreadID;
                record.RelativeItemName = blogThread.Subject;
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewBlogComment", toUser.Language, ApplicationIDs.Instance().Blog()), SPBHtmlHelper.Instance().UserDisplayNameLink(blogComment.UserID, blogComment.Author, true), GetBlogCommentSubjectWithHyperlink(blogThread, blogComment));
                record.RelativeItemUrl = SiteUrls.Instance().ShowBlogThread(toUser.UserName, blogThread, blogComment.PostID);
                record.Body = blogComment.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        #endregion

        /// <summary>
        /// 获取带链接的博客文章或评论的html代码
        /// </summary>
        private static string GetBlogCommentSubjectWithHyperlink(BlogThread blogThread, BlogComment child)
        {
            if (child != null)
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowBlogThreadGotoPageIndex(blogThread.Owner.UserName, blogThread.ThreadID, child.ParentID > 0 ? child.ParentID : child.PostID, child.PostID), HtmlUtils.TrimHtml(blogThread.Subject, 50));
            else
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowBlogThread(blogThread.Owner.UserName, blogThread), HtmlUtils.TrimHtml(blogThread.Subject, 50));
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;

    }
}
