//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Blog.Modules
{
    /// <summary>
    /// 벩صĻ
    /// </summary>
    public class DisposePointForBlog : IBlogModule
    {
        #region IPostModule Ա

        public void Init(BlogEventManager bem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                bem.AfterPointChangeOfBlogThread += new PointChangeOfBlogThreadHandler(bem_AfterPointChangeOfBlogThread);
                bem.AfterPointChangeOfBlogComment += new PointChangeOfBlogCommentHandler(bem_AfterPointChangeOfBlogComment);
                bem.AfterBlogThreadSetEssential += new BlogThreadEventHandler(bem_AfterBlogThreadSetEssential);
                bem.AfterBlogThreadSetSticky += new BlogThreadEventHandler(bem_AfterBlogThreadSetSticky);
            }
        }

        void bem_AfterPointChangeOfBlogThread(BlogThread blogThread, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;

            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateBlogThread());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateBlogThread", blogThread.Owner.Language, ApplicationIDs.Instance().Blog()), blogThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_BlogThreadAuditingSuccess", blogThread.Owner.Language, ApplicationIDs.Instance().Blog()), blogThread.Subject);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteBlogThread());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteBlogThread", blogThread.Owner.Language, ApplicationIDs.Instance().Blog()), blogThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_BlogThreadAuditingFail", blogThread.Owner.Language, ApplicationIDs.Instance().Blog()), blogThread.Subject);
            }
            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, blogThread.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            Points.CreateUserPointRecords(records);
        }

        void bem_AfterPointChangeOfBlogComment(BlogComment blogComment, SpaceBuilder.Common.GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            BlogThread blogThread = BlogThreads.GetThread(blogComment.ThreadID, null, false);
            if (userPointDirection == UserPointDirection.Input)
            {

                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateBlogComment());
                if (e.State == ObjectState.Create)
                {
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateBlogComment", blogComment.User.Language, ApplicationIDs.Instance().Blog()), HtmlUtils.TrimHtml(blogComment.Body, 128));
                }
                else
                {
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_BlogCommentAuditingSuccess", blogComment.User.Language, ApplicationIDs.Instance().Blog()), HtmlUtils.TrimHtml(blogComment.Body, 128));
                }
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteBlogComment());
                if (e.State == ObjectState.Delete)
                {
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteBlogComment", blogComment.User.Language, ApplicationIDs.Instance().Blog()), HtmlUtils.TrimHtml(blogComment.Body, 128));
                }
                else
                {
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_BlogCommentAuditingFail", blogComment.User.Language, ApplicationIDs.Instance().Blog()), HtmlUtils.TrimHtml(blogComment.Body, 128));
                }
            }

            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, blogComment.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            Points.CreateUserPointRecords(records);
        }

        void bem_AfterBlogThreadSetEssential(BlogThread blogThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Update && blogThread.IsEssential)
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;

                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().SetEssentialBlogThread());

                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_SetEssentialBlogThread", blogThread.Owner.Language, ApplicationIDs.Instance().Blog()), blogThread.Subject);

                if (role == null)
                    return;
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, blogThread.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                SpaceBuilder.Common.Points.CreateUserPointRecords(records);
            }
        }

        void bem_AfterBlogThreadSetSticky(BlogThread blogThread, GlobalEventArgs e)
        {
            //TODO:ȷSpecialOrderΪʱö
            if (e.State == ObjectState.Update && blogThread.SpecialOrder > 0)
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;

                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().SetStickyBlogThread());

                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_SetStickyBlogThread", blogThread.Owner.Language, ApplicationIDs.Instance().Blog()), blogThread.Subject);

                if (role == null)
                    return;
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, blogThread.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                SpaceBuilder.Common.Points.CreateUserPointRecords(records);
            }
        }

        #endregion
    }
}
