//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;

namespace SpaceBuilder.Blog.Modules
{
    /// <summary>
    /// ƼϢصĻ
    /// </summary>
    public class DisposePointForReCommendedBlogThread : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager gem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                gem.RecommendedItemChange += new RecommendedItemEventHandler(gem_RecommendedItemChange);
            }
        }
        #endregion


        void gem_RecommendedItemChange(RecommendedItem commendedItem, GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().Blog()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(commendedItem.AuthorUserID, false);
                if (user == null)
                    return;
                string userPointRecordDescription = string.Empty;
                string itemKey = string.Empty;
                UserPointItemRole role = null;
                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_RecommendedBlogThread",
                user.Language, e.ApplicationID), commendedItem.ItemName);
                itemKey = UserPointItemKeys.Instance().RecommendedBlogThread();
                role = Points.GetUserPointItemRole(itemKey);
                if (role == null)
                    return;
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, commendedItem.AuthorUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);
            }
        }

        void PopulateUserPointRecords(List<UserPointRecord> records, UserPointItemRole role, int userID, string userPointRecordDescription)
        {
            if (role != null)
            {
                string roleItemName = role.GetMultilingualItemName(Globals.GetCurrentUserLanguage());
                if (role.HasBasicPoints)
                {
                    UserPointRecord record = new UserPointRecord();
                    record.Description = userPointRecordDescription;
                    record.PointCategory = UserPointCategory.Basic;
                    record.PointItemName = roleItemName;
                    record.Points = role.BasicPoints;
                    record.UserID = userID;
                    records.Add(record);
                }
                if (role.HasReportPoints)
                {
                    UserPointRecord record = new UserPointRecord();
                    record.Description = userPointRecordDescription;
                    record.PointCategory = UserPointCategory.Report;
                    record.PointItemName = roleItemName;
                    record.Points = role.ReportPoints;
                    record.UserID = userID;
                    records.Add(record);
                }
                if (role.HasCreditPoints)
                {
                    UserPointRecord record = new UserPointRecord();
                    record.Description = userPointRecordDescription;
                    record.PointCategory = UserPointCategory.Credit;
                    record.PointItemName = roleItemName;
                    record.Points = role.CreditPoints;
                    record.UserID = userID;
                    records.Add(record);
                }
                if (role.HasTradePoints)
                {
                    UserPointRecord record = new UserPointRecord();
                    record.Description = userPointRecordDescription;
                    record.PointCategory = UserPointCategory.Trade;
                    record.PointItemName = roleItemName;
                    record.Points = role.TradePoints;
                    record.UserID = userID;
                    records.Add(record);
                }
            }
        }

    }
}