﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Common;

namespace SpaceBuilder.Blog.Modules
{
    public class FilterBlogAttachmentsInBody : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.FilterAttachmentInBody += new FilterAttachmentInBodyEventHandler(em_FilterAttachmentInBody);
        }

        void em_FilterAttachmentInBody(ref string body, int applicationID, IList<Attachment> attachments)
        {
            if (applicationID == ApplicationIDs.Instance().Blog())
                body = Globals.ConvertUBB2HtmlFromBody(body, SiteUrls.Instance().DownloadBlogAttachment, attachments);
        }

        #endregion
    }
}
