﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Blog.Modules
{
    public class ToggleTemporaryAttachmentsForBlog : IBlogModule
    {
        #region IBlogModule 成员

        public void Init(BlogEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterBlogThreadChange += new BlogThreadEventHandler(em_AfterBlogThreadChange);
        }

        void em_AfterBlogThreadChange(BlogThread blogThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                if (SPBConfig.Instance().EnableDistributedStorage)
                {
                    SpaceBuilder.Blog.Advanced.WCF.AttachmentManageClient client = new SpaceBuilder.Blog.Advanced.WCF.AttachmentManageClient("BlogToggleTemporaryAttachments");
                    client.ToggleTemporaryAttachmentsForBlog(blogThread.ThreadID, blogThread.OwnerUserID, null);
                }
                else
                {
                    BlogAttachmentManager.Instance().ToggleTemporaryAttachments(blogThread.ThreadID, blogThread.OwnerUserID, null);
                }
            }
        }

        #endregion
    }
}
