﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.Blog
{
    public static class SPBHtmlHelperExtensions
    {
        /// <summary>
        /// 生成CommentModerationDropDownList的Html标签，CommentModerationDropDownList用于设置文章评论的审核规则
        /// </summary>
        /// <param name="name">用户设置该控件的name</param>
        /// <param name="name">该控件的ID</param>
        /// <param name="cssClass">设置样式</param>
        public static string CommentModerationDropDownList(this SPBHtmlHelper spbHtmlHelper, string name, string cssClass, CommentModerationType? commentModerationType)
        {
            string commentModerationDropDownList = string.Empty;
            if (commentModerationType == null)
            {
                commentModerationDropDownList = string.Format(" <select name=\"{0}\" id=\"{0}\" class=\"{1}\">", name, cssClass);
                commentModerationDropDownList = commentModerationDropDownList + string.Format("<option selected=\"selected\" value=\"{0}\">" + ResourceManager.GetString("Enum_CommentModerationType_None", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.None.ToString());
                commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_CommentModerationType_Anonymous", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.Anonymous.ToString());
                commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_CommentModerationType_All", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.All.ToString());
                commentModerationDropDownList = commentModerationDropDownList + "</select>";
            }
            else
            {
                commentModerationDropDownList = string.Format(" <select name=\"{0}\" id=\"{0}\" class=\"{1}\">", name, cssClass);
                switch ((CommentModerationType)commentModerationType)
                {
                    case CommentModerationType.All:
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\" >" + ResourceManager.GetString("Enum_CommentModerationType_None", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.None.ToString());
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\" >" + ResourceManager.GetString("Enum_CommentModerationType_Anonymous", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.Anonymous.ToString());
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\"  selected=\"selected\">" + ResourceManager.GetString("Enum_CommentModerationType_All", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.All.ToString());
                        break;
                    case CommentModerationType.Anonymous:
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_CommentModerationType_None", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.None.ToString());
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\" selected=\"selected\" >" + ResourceManager.GetString("Enum_CommentModerationType_Anonymous", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.Anonymous.ToString());
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_CommentModerationType_All", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.All.ToString());
                        break;
                    case CommentModerationType.None:
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\" selected=\"selected\">" + ResourceManager.GetString("Enum_CommentModerationType_None", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.None.ToString());
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_CommentModerationType_Anonymous", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.Anonymous.ToString());
                        commentModerationDropDownList = commentModerationDropDownList + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_CommentModerationType_All", Globals.GetCurrentUserLanguage()) + "</option>", CommentModerationType.All.ToString());
                        break;
                    default:
                        break;
                }
                commentModerationDropDownList = commentModerationDropDownList + "</select>";
            }
            return commentModerationDropDownList;
        }


        /// <summary>
        /// 获取博客附件的缩略图
        /// </summary>
        public static string ShowBlogAttachmentThumbnail(this SPBHtmlHelper spbHtmlHelper, Attachment attachment, ContentTypeThumbnailSize thumbnailSize)
        {
            return spbHtmlHelper.ShowAttachmentThumbnail(attachment, thumbnailSize, SiteUrls.Instance().DownloadBlogAttachment);
        }
    }
}
