﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 在Lucene索引文件blogthread的字段
    /// </summary>
    public static class BlogThreadIndexFields
    {
        public static readonly string UserID;
        public static readonly string ThreadID;
        public static readonly string Author;
        public static readonly string Subject;
        public static readonly string Body;
        public static readonly string UserCategoryID;
        public static readonly string SiteCategoryID;
        public static readonly string Tags;
        public static readonly string TagKeywords;
        public static readonly string PrivacyStatus;
        public static readonly string AuditingStatus;
        public static readonly string PostDate;


        static BlogThreadIndexFields()
        {
            UserID = "UserID";
            ThreadID = "ThreadID";
            Author = "Author";
            Subject = "Subject";
            Body = "Body";
            UserCategoryID = "UserCategoryID";
            SiteCategoryID = "SiteCategoryID";
            Tags = "Tags";
            PrivacyStatus = "PrivacyStatus";
            AuditingStatus = "AuditingStatus";
            PostDate = "PostDate";
        }
    }
}
