﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Tasks;
using System.Xml;
using SpaceBuilder.Common;

using SpaceBuilder.Blog;
using SpaceBuilder.Utils;
using System.Xml.Linq;


namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 定期把BlogThread的变更情况更新到Lucene索引文件
    /// </summary>
    public class BlogThreadIndexTask : TaskBase
    {
        /// <summary>
        /// 每次更新索引的最大数目
        /// </summary>
        private int count = 1000;

        #region ITask Members

        public override void ExecuteTask(XElement xElement)
        {
            XAttribute countNode = xElement.Attribute("count");
            if (countNode != null)
            {
                int.TryParse(countNode.Value, out count);
            }
            IndexPosts(count);
        }

        #endregion

        private void IndexPosts(int count)
        {
            SearchDataProvider dp = SearchDataProvider.Instance();
            IList<ItemForIndex> itemsForIndex = dp.GetItemsForIndex(BlogSearchTypeSettings.CODE, count);

            List<ItemForIndex> createItems = new List<ItemForIndex>();
            List<ItemForIndex> updateItems = new List<ItemForIndex>();
            List<ItemForIndex> deleteItems = new List<ItemForIndex>();

            BlogSearchManager blogSearchManager = BlogSearchManager.Instance();
            foreach (ItemForIndex item in itemsForIndex)
            {
                if (item.DataAction == ObjectState.Create)
                    createItems.Add(item);
                else if (item.DataAction == ObjectState.Update)
                    updateItems.Add(item);
                else if (item.DataAction == ObjectState.Delete)
                    deleteItems.Add(item);
            }

            #region Insert

            IList<BlogThread> createPosts = new List<BlogThread>();
            foreach (ItemForIndex item in createItems)
            {
                BlogThread thread = BlogThreads.GetThread(item.ItemID, PrivacyStatuses.Public, true);
                if (thread != null)
                    createPosts.Add(thread);
            }

            if (blogSearchManager.Insert(createPosts))
            {
                dp.DeleteItemsForIndex(createItems);
            }
            else
            {
                foreach (ItemForIndex item in createItems)
                {
                    item.DataAction = ObjectState.Update;
                }
                dp.UpdateItemsForIndex(createItems);
            }

            #endregion

            #region Update

            IList<BlogThread> updatePosts = new List<BlogThread>();
            foreach (ItemForIndex item in updateItems)
            {
                BlogThread thread = BlogThreads.GetThread(item.ItemID, null, true);
                if (thread != null)
                    updatePosts.Add(thread);
            }

            if (blogSearchManager.Update(updatePosts, m => m.Select(n => n.ThreadID).ToList(), BlogThreadIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(updateItems);
            }

            #endregion

            #region Delete
            if (deleteItems.Count > 0 && blogSearchManager.Delete(deleteItems.Select(n => n.ItemID).ToList(), BlogThreadIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(deleteItems);
            }
            #endregion
        }

     
    }
}
