﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Blog;
using SpaceBuilder.Common;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 处理博客主题的变更，把变更情况记录到数据库，并在<see cref="SpaceBuilder.LuceneSearch.BlogThreadIndexTask"/>批量更新到Lucene索引文件中
    /// </summary>
    public class PrepareForBlogThreadIndexModule : IBlogModule
    {
        #region IBlogModule 成员

        public void Init(BlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterBlogThreadChange += new BlogThreadEventHandler(em_AfterBlogThreadChange);
        }

        void em_AfterBlogThreadChange(BlogThread blogThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((blogThread != null) && (e.State == ObjectState.Create || e.State == ObjectState.Update || e.State == ObjectState.Delete))
            {
                if (blogThread.PrivacyStatus == PrivacyStatuses.Public)
                {
                    ItemForIndex item = new ItemForIndex();
                    item.ItemID = blogThread.ThreadID;
                    item.SearchTypeCode = BlogSearchTypeSettings.CODE;
                    item.DataAction = e.State;

                    SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
                }
            }
        }

        #endregion
    }
}
